/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ReaderGroupDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15522;
  }

  // Properties.
  protected final PascalString name;
  protected final boolean enabled;
  protected final MessageSecurityMode securityMode;
  protected final PascalString securityGroupId;
  protected final List<EndpointDescription> securityKeyServices;
  protected final long maxNetworkMessageSize;
  protected final List<KeyValuePair> groupProperties;
  protected final ExtensionObject transportSettings;
  protected final ExtensionObject messageSettings;
  protected final List<DataSetReaderDataType> dataSetReaders;

  public ReaderGroupDataType(
      PascalString name,
      boolean enabled,
      MessageSecurityMode securityMode,
      PascalString securityGroupId,
      List<EndpointDescription> securityKeyServices,
      long maxNetworkMessageSize,
      List<KeyValuePair> groupProperties,
      ExtensionObject transportSettings,
      ExtensionObject messageSettings,
      List<DataSetReaderDataType> dataSetReaders) {
    super();
    this.name = name;
    this.enabled = enabled;
    this.securityMode = securityMode;
    this.securityGroupId = securityGroupId;
    this.securityKeyServices = securityKeyServices;
    this.maxNetworkMessageSize = maxNetworkMessageSize;
    this.groupProperties = groupProperties;
    this.transportSettings = transportSettings;
    this.messageSettings = messageSettings;
    this.dataSetReaders = dataSetReaders;
  }

  public PascalString getName() {
    return name;
  }

  public boolean getEnabled() {
    return enabled;
  }

  public MessageSecurityMode getSecurityMode() {
    return securityMode;
  }

  public PascalString getSecurityGroupId() {
    return securityGroupId;
  }

  public List<EndpointDescription> getSecurityKeyServices() {
    return securityKeyServices;
  }

  public long getMaxNetworkMessageSize() {
    return maxNetworkMessageSize;
  }

  public List<KeyValuePair> getGroupProperties() {
    return groupProperties;
  }

  public ExtensionObject getTransportSettings() {
    return transportSettings;
  }

  public ExtensionObject getMessageSettings() {
    return messageSettings;
  }

  public List<DataSetReaderDataType> getDataSetReaders() {
    return dataSetReaders;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ReaderGroupDataType");

    // Simple Field (name)
    writeSimpleField("name", name, writeComplex(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (enabled)
    writeSimpleField("enabled", enabled, writeBoolean(writeBuffer));

    // Simple Field (securityMode)
    writeSimpleEnumField(
        "securityMode",
        "MessageSecurityMode",
        securityMode,
        writeEnum(
            MessageSecurityMode::getValue,
            MessageSecurityMode::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (securityGroupId)
    writeSimpleField("securityGroupId", securityGroupId, writeComplex(writeBuffer));

    // Implicit Field (noOfSecurityKeyServices) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfSecurityKeyServices =
        (int) ((((getSecurityKeyServices()) == (null)) ? -(1) : COUNT(getSecurityKeyServices())));
    writeImplicitField(
        "noOfSecurityKeyServices", noOfSecurityKeyServices, writeSignedInt(writeBuffer, 32));

    // Array Field (securityKeyServices)
    writeComplexTypeArrayField("securityKeyServices", securityKeyServices, writeBuffer);

    // Simple Field (maxNetworkMessageSize)
    writeSimpleField(
        "maxNetworkMessageSize", maxNetworkMessageSize, writeUnsignedLong(writeBuffer, 32));

    // Implicit Field (noOfGroupProperties) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfGroupProperties =
        (int) ((((getGroupProperties()) == (null)) ? -(1) : COUNT(getGroupProperties())));
    writeImplicitField("noOfGroupProperties", noOfGroupProperties, writeSignedInt(writeBuffer, 32));

    // Array Field (groupProperties)
    writeComplexTypeArrayField("groupProperties", groupProperties, writeBuffer);

    // Simple Field (transportSettings)
    writeSimpleField("transportSettings", transportSettings, writeComplex(writeBuffer));

    // Simple Field (messageSettings)
    writeSimpleField("messageSettings", messageSettings, writeComplex(writeBuffer));

    // Implicit Field (noOfDataSetReaders) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDataSetReaders =
        (int) ((((getDataSetReaders()) == (null)) ? -(1) : COUNT(getDataSetReaders())));
    writeImplicitField("noOfDataSetReaders", noOfDataSetReaders, writeSignedInt(writeBuffer, 32));

    // Array Field (dataSetReaders)
    writeComplexTypeArrayField("dataSetReaders", dataSetReaders, writeBuffer);

    writeBuffer.popContext("ReaderGroupDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ReaderGroupDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (enabled)
    lengthInBits += 1;

    // Simple field (securityMode)
    lengthInBits += 32;

    // Simple field (securityGroupId)
    lengthInBits += securityGroupId.getLengthInBits();

    // Implicit Field (noOfSecurityKeyServices)
    lengthInBits += 32;

    // Array field
    if (securityKeyServices != null) {
      int i = 0;
      for (EndpointDescription element : securityKeyServices) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= securityKeyServices.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (maxNetworkMessageSize)
    lengthInBits += 32;

    // Implicit Field (noOfGroupProperties)
    lengthInBits += 32;

    // Array field
    if (groupProperties != null) {
      int i = 0;
      for (KeyValuePair element : groupProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= groupProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (transportSettings)
    lengthInBits += transportSettings.getLengthInBits();

    // Simple field (messageSettings)
    lengthInBits += messageSettings.getLengthInBits();

    // Implicit Field (noOfDataSetReaders)
    lengthInBits += 32;

    // Array field
    if (dataSetReaders != null) {
      int i = 0;
      for (DataSetReaderDataType element : dataSetReaders) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= dataSetReaders.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ReaderGroupDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString name =
        readSimpleField(
            "name", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean enabled = readSimpleField("enabled", readBoolean(readBuffer));

    MessageSecurityMode securityMode =
        readEnumField(
            "securityMode",
            "MessageSecurityMode",
            readEnum(MessageSecurityMode::enumForValue, readUnsignedLong(readBuffer, 32)));

    PascalString securityGroupId =
        readSimpleField(
            "securityGroupId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfSecurityKeyServices =
        readImplicitField("noOfSecurityKeyServices", readSignedInt(readBuffer, 32));

    List<EndpointDescription> securityKeyServices =
        readCountArrayField(
            "securityKeyServices",
            readComplex(
                () ->
                    (EndpointDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (314)),
                readBuffer),
            noOfSecurityKeyServices);

    long maxNetworkMessageSize =
        readSimpleField("maxNetworkMessageSize", readUnsignedLong(readBuffer, 32));

    int noOfGroupProperties =
        readImplicitField("noOfGroupProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> groupProperties =
        readCountArrayField(
            "groupProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfGroupProperties);

    ExtensionObject transportSettings =
        readSimpleField(
            "transportSettings",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    ExtensionObject messageSettings =
        readSimpleField(
            "messageSettings",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    int noOfDataSetReaders = readImplicitField("noOfDataSetReaders", readSignedInt(readBuffer, 32));

    List<DataSetReaderDataType> dataSetReaders =
        readCountArrayField(
            "dataSetReaders",
            readComplex(
                () ->
                    (DataSetReaderDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (15625)),
                readBuffer),
            noOfDataSetReaders);

    readBuffer.closeContext("ReaderGroupDataType");
    // Create the instance
    return new ReaderGroupDataTypeBuilderImpl(
        name,
        enabled,
        securityMode,
        securityGroupId,
        securityKeyServices,
        maxNetworkMessageSize,
        groupProperties,
        transportSettings,
        messageSettings,
        dataSetReaders);
  }

  public static class ReaderGroupDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString name;
    private final boolean enabled;
    private final MessageSecurityMode securityMode;
    private final PascalString securityGroupId;
    private final List<EndpointDescription> securityKeyServices;
    private final long maxNetworkMessageSize;
    private final List<KeyValuePair> groupProperties;
    private final ExtensionObject transportSettings;
    private final ExtensionObject messageSettings;
    private final List<DataSetReaderDataType> dataSetReaders;

    public ReaderGroupDataTypeBuilderImpl(
        PascalString name,
        boolean enabled,
        MessageSecurityMode securityMode,
        PascalString securityGroupId,
        List<EndpointDescription> securityKeyServices,
        long maxNetworkMessageSize,
        List<KeyValuePair> groupProperties,
        ExtensionObject transportSettings,
        ExtensionObject messageSettings,
        List<DataSetReaderDataType> dataSetReaders) {
      this.name = name;
      this.enabled = enabled;
      this.securityMode = securityMode;
      this.securityGroupId = securityGroupId;
      this.securityKeyServices = securityKeyServices;
      this.maxNetworkMessageSize = maxNetworkMessageSize;
      this.groupProperties = groupProperties;
      this.transportSettings = transportSettings;
      this.messageSettings = messageSettings;
      this.dataSetReaders = dataSetReaders;
    }

    public ReaderGroupDataType build() {
      ReaderGroupDataType readerGroupDataType =
          new ReaderGroupDataType(
              name,
              enabled,
              securityMode,
              securityGroupId,
              securityKeyServices,
              maxNetworkMessageSize,
              groupProperties,
              transportSettings,
              messageSettings,
              dataSetReaders);
      return readerGroupDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ReaderGroupDataType)) {
      return false;
    }
    ReaderGroupDataType that = (ReaderGroupDataType) o;
    return (getName() == that.getName())
        && (getEnabled() == that.getEnabled())
        && (getSecurityMode() == that.getSecurityMode())
        && (getSecurityGroupId() == that.getSecurityGroupId())
        && (getSecurityKeyServices() == that.getSecurityKeyServices())
        && (getMaxNetworkMessageSize() == that.getMaxNetworkMessageSize())
        && (getGroupProperties() == that.getGroupProperties())
        && (getTransportSettings() == that.getTransportSettings())
        && (getMessageSettings() == that.getMessageSettings())
        && (getDataSetReaders() == that.getDataSetReaders())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getName(),
        getEnabled(),
        getSecurityMode(),
        getSecurityGroupId(),
        getSecurityKeyServices(),
        getMaxNetworkMessageSize(),
        getGroupProperties(),
        getTransportSettings(),
        getMessageSettings(),
        getDataSetReaders());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
