/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class NodeIdTypeDefinition implements Message {

  // Abstract accessors for discriminator values.
  public abstract NodeIdType getNodeType();

  public NodeIdTypeDefinition() {
    super();
  }

  public abstract String getIdentifier();

  public abstract short getNamespace();

  protected abstract void serializeNodeIdTypeDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NodeIdTypeDefinition");

    // Discriminator Field (nodeType) (Used as input to a switch field)
    writeDiscriminatorEnumField(
        "nodeType",
        "NodeIdType",
        getNodeType(),
        writeEnum(NodeIdType::getValue, NodeIdType::name, writeUnsignedByte(writeBuffer, 6)));

    // Switch field (Serialize the sub-type)
    serializeNodeIdTypeDefinitionChild(writeBuffer);

    writeBuffer.popContext("NodeIdTypeDefinition");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    NodeIdTypeDefinition _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Discriminator Field (nodeType)
    lengthInBits += 6;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static NodeIdTypeDefinition staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("NodeIdTypeDefinition");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NodeIdType nodeType =
        readDiscriminatorEnumField(
            "nodeType",
            "NodeIdType",
            readEnum(NodeIdType::enumForValue, readUnsignedByte(readBuffer, 6)));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    NodeIdTypeDefinitionBuilder builder = null;
    if (EvaluationHelper.equals(nodeType, NodeIdType.nodeIdTypeTwoByte)) {
      builder = NodeIdTwoByte.staticParseNodeIdTypeDefinitionBuilder(readBuffer);
    } else if (EvaluationHelper.equals(nodeType, NodeIdType.nodeIdTypeFourByte)) {
      builder = NodeIdFourByte.staticParseNodeIdTypeDefinitionBuilder(readBuffer);
    } else if (EvaluationHelper.equals(nodeType, NodeIdType.nodeIdTypeNumeric)) {
      builder = NodeIdNumeric.staticParseNodeIdTypeDefinitionBuilder(readBuffer);
    } else if (EvaluationHelper.equals(nodeType, NodeIdType.nodeIdTypeString)) {
      builder = NodeIdString.staticParseNodeIdTypeDefinitionBuilder(readBuffer);
    } else if (EvaluationHelper.equals(nodeType, NodeIdType.nodeIdTypeGuid)) {
      builder = NodeIdGuid.staticParseNodeIdTypeDefinitionBuilder(readBuffer);
    } else if (EvaluationHelper.equals(nodeType, NodeIdType.nodeIdTypeByteString)) {
      builder = NodeIdByteString.staticParseNodeIdTypeDefinitionBuilder(readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "nodeType="
              + nodeType
              + "]");
    }

    readBuffer.closeContext("NodeIdTypeDefinition");
    // Create the instance
    NodeIdTypeDefinition _nodeIdTypeDefinition = builder.build();
    return _nodeIdTypeDefinition;
  }

  public interface NodeIdTypeDefinitionBuilder {
    NodeIdTypeDefinition build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NodeIdTypeDefinition)) {
      return false;
    }
    NodeIdTypeDefinition that = (NodeIdTypeDefinition) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
