/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.canopen.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.math.BigInteger;
import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;
import org.apache.plc4x.java.spi.values.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

// Code generated by code-generation. DO NOT EDIT.

public class DataItem {

  private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

  public static PlcValue staticParse(ReadBuffer readBuffer, CANOpenDataType dataType, Integer size)
      throws ParseException {
    if (EvaluationHelper.equals(dataType, CANOpenDataType.BOOLEAN)) { // BOOL
      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED8)) { // USINT
      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED16)) { // UINT
      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED24)) { // UDINT
      int value = readSimpleField("value", readUnsignedInt(readBuffer, 24));
      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED32)) { // UDINT
      long value = readSimpleField("value", readUnsignedLong(readBuffer, 32));
      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED40)) { // ULINT
      long value = readSimpleField("value", readUnsignedLong(readBuffer, 40));
      return new PlcULINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED48)) { // ULINT
      long value = readSimpleField("value", readUnsignedLong(readBuffer, 48));
      return new PlcULINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED56)) { // ULINT
      long value = readSimpleField("value", readUnsignedLong(readBuffer, 56));
      return new PlcULINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED64)) { // ULINT
      BigInteger value = readSimpleField("value", readUnsignedBigInteger(readBuffer, 64));
      return new PlcULINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER8)) { // SINT
      byte value = readSimpleField("value", readSignedByte(readBuffer, 8));
      return new PlcSINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER16)) { // INT
      short value = readSimpleField("value", readSignedShort(readBuffer, 16));
      return new PlcINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER24)) { // DINT
      int value = readSimpleField("value", readSignedInt(readBuffer, 24));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER32)) { // DINT
      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER40)) { // LINT
      long value = readSimpleField("value", readSignedLong(readBuffer, 40));
      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER48)) { // LINT
      long value = readSimpleField("value", readSignedLong(readBuffer, 48));
      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER56)) { // LINT
      long value = readSimpleField("value", readSignedLong(readBuffer, 56));
      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER64)) { // LINT
      long value = readSimpleField("value", readSignedLong(readBuffer, 64));
      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.REAL32)) { // REAL
      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.REAL64)) { // LREAL
      double value = readSimpleField("value", readDouble(readBuffer, 64));
      return new PlcLREAL(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.RECORD)) { // List
      byte[] value = readBuffer.readByteArray("value", Math.toIntExact(size));
      return new PlcRawByteArray(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.OCTET_STRING)) { // STRING
      String value = readSimpleField("value", readString(readBuffer, size));
      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.VISIBLE_STRING)) { // STRING
      String value = readSimpleField("value", readString(readBuffer, size));
      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNICODE_STRING)) { // STRING
      String value = readSimpleField("value", readString(readBuffer, (size) / (8)));
      return new PlcSTRING(value);
    }
    return null;
  }

  public static int getLengthInBytes(PlcValue _value, CANOpenDataType dataType, Integer size) {
    return (int) Math.ceil((float) getLengthInBits(_value, dataType, size) / 8.0);
  }

  public static int getLengthInBits(PlcValue _value, CANOpenDataType dataType, Integer size) {
    int lengthInBits = 0;
    if (EvaluationHelper.equals(dataType, CANOpenDataType.BOOLEAN)) { // BOOL
      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED8)) { // USINT
      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED16)) { // UINT
      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED24)) { // UDINT
      // Simple field (value)
      lengthInBits += 24;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED32)) { // UDINT
      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED40)) { // ULINT
      // Simple field (value)
      lengthInBits += 40;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED48)) { // ULINT
      // Simple field (value)
      lengthInBits += 48;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED56)) { // ULINT
      // Simple field (value)
      lengthInBits += 56;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED64)) { // ULINT
      // Simple field (value)
      lengthInBits += 64;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER8)) { // SINT
      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER16)) { // INT
      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER24)) { // DINT
      // Simple field (value)
      lengthInBits += 24;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER32)) { // DINT
      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER40)) { // LINT
      // Simple field (value)
      lengthInBits += 40;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER48)) { // LINT
      // Simple field (value)
      lengthInBits += 48;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER56)) { // LINT
      // Simple field (value)
      lengthInBits += 56;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER64)) { // LINT
      // Simple field (value)
      lengthInBits += 64;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.REAL32)) { // REAL
      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.REAL64)) { // LREAL
      // Simple field (value)
      lengthInBits += 64;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.RECORD)) { // List
      // Array field
      if (_value != null) {
        lengthInBits += 8 * _value.getRaw().length;
      }
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.OCTET_STRING)) { // STRING
      // Simple field (value)
      lengthInBits += size;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.VISIBLE_STRING)) { // STRING
      // Simple field (value)
      lengthInBits += size;
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNICODE_STRING)) { // STRING
      // Simple field (value)
      lengthInBits += (size) / (8);
    }

    return lengthInBits;
  }

  public static void staticSerialize(
      WriteBuffer writeBuffer, PlcValue _value, CANOpenDataType dataType, Integer size)
      throws SerializationException {
    staticSerialize(writeBuffer, _value, dataType, size, ByteOrder.BIG_ENDIAN);
  }

  public static void staticSerialize(
      WriteBuffer writeBuffer,
      PlcValue _value,
      CANOpenDataType dataType,
      Integer size,
      ByteOrder byteOrder)
      throws SerializationException {
    if (EvaluationHelper.equals(dataType, CANOpenDataType.BOOLEAN)) { // BOOL
      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED8)) { // USINT
      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED16)) { // UINT
      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED24)) { // UDINT
      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 24));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED32)) { // UDINT
      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED40)) { // ULINT
      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeUnsignedLong(writeBuffer, 40));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED48)) { // ULINT
      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeUnsignedLong(writeBuffer, 48));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED56)) { // ULINT
      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeUnsignedLong(writeBuffer, 56));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNSIGNED64)) { // ULINT
      // Simple Field (value)
      writeSimpleField(
          "value", (BigInteger) _value.getBigInteger(), writeUnsignedBigInteger(writeBuffer, 64));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER8)) { // SINT
      // Simple Field (value)
      writeSimpleField("value", (byte) _value.getByte(), writeSignedByte(writeBuffer, 8));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER16)) { // INT
      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeSignedShort(writeBuffer, 16));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER24)) { // DINT
      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 24));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER32)) { // DINT
      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER40)) { // LINT
      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeSignedLong(writeBuffer, 40));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER48)) { // LINT
      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeSignedLong(writeBuffer, 48));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER56)) { // LINT
      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeSignedLong(writeBuffer, 56));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.INTEGER64)) { // LINT
      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeSignedLong(writeBuffer, 64));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.REAL32)) { // REAL
      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.REAL64)) { // LREAL
      // Simple Field (value)
      writeSimpleField("value", (double) _value.getDouble(), writeDouble(writeBuffer, 64));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.RECORD)) { // List
      // Array Field (value)
      writeByteArrayField("value", _value.getRaw(), writeByteArray(writeBuffer, 8));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.OCTET_STRING)) { // STRING
      // Simple Field (value)
      writeSimpleField("value", (String) _value.getString(), writeString(writeBuffer, size));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.VISIBLE_STRING)) { // STRING
      // Simple Field (value)
      writeSimpleField("value", (String) _value.getString(), writeString(writeBuffer, size));
    } else if (EvaluationHelper.equals(dataType, CANOpenDataType.UNICODE_STRING)) { // STRING
      // Simple Field (value)
      writeSimpleField(
          "value", (String) _value.getString(), writeString(writeBuffer, (size) / (8)));
    }
  }
}
