/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Structure is the corresponding interface of Structure
type Structure interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsStructure is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsStructure()
	// CreateBuilder creates a StructureBuilder
	CreateStructureBuilder() StructureBuilder
}

// _Structure is the data-structure of this message
type _Structure struct {
}

var _ Structure = (*_Structure)(nil)

// NewStructure factory function for _Structure
func NewStructure() *_Structure {
	return &_Structure{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// StructureBuilder is a builder for Structure
type StructureBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() StructureBuilder
	// Build builds the Structure or returns an error if something is wrong
	Build() (Structure, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() Structure
}

// NewStructureBuilder() creates a StructureBuilder
func NewStructureBuilder() StructureBuilder {
	return &_StructureBuilder{_Structure: new(_Structure)}
}

type _StructureBuilder struct {
	*_Structure

	collectedErr []error
}

var _ (StructureBuilder) = (*_StructureBuilder)(nil)

func (b *_StructureBuilder) WithMandatoryFields() StructureBuilder {
	return b
}

func (b *_StructureBuilder) Build() (Structure, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._Structure.deepCopy(), nil
}

func (b *_StructureBuilder) MustBuild() Structure {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_StructureBuilder) DeepCopy() any {
	_copy := b.CreateStructureBuilder().(*_StructureBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateStructureBuilder creates a StructureBuilder
func (b *_Structure) CreateStructureBuilder() StructureBuilder {
	if b == nil {
		return NewStructureBuilder()
	}
	return &_StructureBuilder{_Structure: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastStructure(structType any) Structure {
	if casted, ok := structType.(Structure); ok {
		return casted
	}
	if casted, ok := structType.(*Structure); ok {
		return *casted
	}
	return nil
}

func (m *_Structure) GetTypeName() string {
	return "Structure"
}

func (m *_Structure) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_Structure) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func StructureParse(ctx context.Context, theBytes []byte) (Structure, error) {
	return StructureParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func StructureParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (Structure, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (Structure, error) {
		return StructureParseWithBuffer(ctx, readBuffer)
	}
}

func StructureParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (Structure, error) {
	v, err := (&_Structure{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_Structure) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__structure Structure, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("Structure"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Structure")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("Structure"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Structure")
	}

	return m, nil
}

func (m *_Structure) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_Structure) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("Structure"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for Structure")
	}

	if popErr := writeBuffer.PopContext("Structure"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for Structure")
	}
	return nil
}

func (m *_Structure) IsStructure() {}

func (m *_Structure) DeepCopy() any {
	return m.deepCopy()
}

func (m *_Structure) deepCopy() *_Structure {
	if m == nil {
		return nil
	}
	_StructureCopy := &_Structure{}
	return _StructureCopy
}

func (m *_Structure) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
