/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ReferenceTypeAttributes is the corresponding interface of ReferenceTypeAttributes
type ReferenceTypeAttributes interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetSpecifiedAttributes returns SpecifiedAttributes (property field)
	GetSpecifiedAttributes() uint32
	// GetDisplayName returns DisplayName (property field)
	GetDisplayName() LocalizedText
	// GetDescription returns Description (property field)
	GetDescription() LocalizedText
	// GetWriteMask returns WriteMask (property field)
	GetWriteMask() uint32
	// GetUserWriteMask returns UserWriteMask (property field)
	GetUserWriteMask() uint32
	// GetSymmetric returns Symmetric (property field)
	GetSymmetric() bool
	// GetIsAbstract returns IsAbstract (property field)
	GetIsAbstract() bool
	// GetInverseName returns InverseName (property field)
	GetInverseName() LocalizedText
	// IsReferenceTypeAttributes is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsReferenceTypeAttributes()
	// CreateBuilder creates a ReferenceTypeAttributesBuilder
	CreateReferenceTypeAttributesBuilder() ReferenceTypeAttributesBuilder
}

// _ReferenceTypeAttributes is the data-structure of this message
type _ReferenceTypeAttributes struct {
	ExtensionObjectDefinitionContract
	SpecifiedAttributes uint32
	DisplayName         LocalizedText
	Description         LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	Symmetric           bool
	IsAbstract          bool
	InverseName         LocalizedText
	// Reserved Fields
	reservedField0 *uint8
}

var _ ReferenceTypeAttributes = (*_ReferenceTypeAttributes)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ReferenceTypeAttributes)(nil)

// NewReferenceTypeAttributes factory function for _ReferenceTypeAttributes
func NewReferenceTypeAttributes(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, symmetric bool, isAbstract bool, inverseName LocalizedText) *_ReferenceTypeAttributes {
	if displayName == nil {
		panic("displayName of type LocalizedText for ReferenceTypeAttributes must not be nil")
	}
	if description == nil {
		panic("description of type LocalizedText for ReferenceTypeAttributes must not be nil")
	}
	if inverseName == nil {
		panic("inverseName of type LocalizedText for ReferenceTypeAttributes must not be nil")
	}
	_result := &_ReferenceTypeAttributes{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		SpecifiedAttributes:               specifiedAttributes,
		DisplayName:                       displayName,
		Description:                       description,
		WriteMask:                         writeMask,
		UserWriteMask:                     userWriteMask,
		Symmetric:                         symmetric,
		IsAbstract:                        isAbstract,
		InverseName:                       inverseName,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ReferenceTypeAttributesBuilder is a builder for ReferenceTypeAttributes
type ReferenceTypeAttributesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, symmetric bool, isAbstract bool, inverseName LocalizedText) ReferenceTypeAttributesBuilder
	// WithSpecifiedAttributes adds SpecifiedAttributes (property field)
	WithSpecifiedAttributes(uint32) ReferenceTypeAttributesBuilder
	// WithDisplayName adds DisplayName (property field)
	WithDisplayName(LocalizedText) ReferenceTypeAttributesBuilder
	// WithDisplayNameBuilder adds DisplayName (property field) which is build by the builder
	WithDisplayNameBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) ReferenceTypeAttributesBuilder
	// WithDescription adds Description (property field)
	WithDescription(LocalizedText) ReferenceTypeAttributesBuilder
	// WithDescriptionBuilder adds Description (property field) which is build by the builder
	WithDescriptionBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) ReferenceTypeAttributesBuilder
	// WithWriteMask adds WriteMask (property field)
	WithWriteMask(uint32) ReferenceTypeAttributesBuilder
	// WithUserWriteMask adds UserWriteMask (property field)
	WithUserWriteMask(uint32) ReferenceTypeAttributesBuilder
	// WithSymmetric adds Symmetric (property field)
	WithSymmetric(bool) ReferenceTypeAttributesBuilder
	// WithIsAbstract adds IsAbstract (property field)
	WithIsAbstract(bool) ReferenceTypeAttributesBuilder
	// WithInverseName adds InverseName (property field)
	WithInverseName(LocalizedText) ReferenceTypeAttributesBuilder
	// WithInverseNameBuilder adds InverseName (property field) which is build by the builder
	WithInverseNameBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) ReferenceTypeAttributesBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ReferenceTypeAttributes or returns an error if something is wrong
	Build() (ReferenceTypeAttributes, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ReferenceTypeAttributes
}

// NewReferenceTypeAttributesBuilder() creates a ReferenceTypeAttributesBuilder
func NewReferenceTypeAttributesBuilder() ReferenceTypeAttributesBuilder {
	return &_ReferenceTypeAttributesBuilder{_ReferenceTypeAttributes: new(_ReferenceTypeAttributes)}
}

type _ReferenceTypeAttributesBuilder struct {
	*_ReferenceTypeAttributes

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (ReferenceTypeAttributesBuilder) = (*_ReferenceTypeAttributesBuilder)(nil)

func (b *_ReferenceTypeAttributesBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ReferenceTypeAttributes
}

func (b *_ReferenceTypeAttributesBuilder) WithMandatoryFields(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, symmetric bool, isAbstract bool, inverseName LocalizedText) ReferenceTypeAttributesBuilder {
	return b.WithSpecifiedAttributes(specifiedAttributes).WithDisplayName(displayName).WithDescription(description).WithWriteMask(writeMask).WithUserWriteMask(userWriteMask).WithSymmetric(symmetric).WithIsAbstract(isAbstract).WithInverseName(inverseName)
}

func (b *_ReferenceTypeAttributesBuilder) WithSpecifiedAttributes(specifiedAttributes uint32) ReferenceTypeAttributesBuilder {
	b.SpecifiedAttributes = specifiedAttributes
	return b
}

func (b *_ReferenceTypeAttributesBuilder) WithDisplayName(displayName LocalizedText) ReferenceTypeAttributesBuilder {
	b.DisplayName = displayName
	return b
}

func (b *_ReferenceTypeAttributesBuilder) WithDisplayNameBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) ReferenceTypeAttributesBuilder {
	builder := builderSupplier(b.DisplayName.CreateLocalizedTextBuilder())
	var err error
	b.DisplayName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_ReferenceTypeAttributesBuilder) WithDescription(description LocalizedText) ReferenceTypeAttributesBuilder {
	b.Description = description
	return b
}

func (b *_ReferenceTypeAttributesBuilder) WithDescriptionBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) ReferenceTypeAttributesBuilder {
	builder := builderSupplier(b.Description.CreateLocalizedTextBuilder())
	var err error
	b.Description, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_ReferenceTypeAttributesBuilder) WithWriteMask(writeMask uint32) ReferenceTypeAttributesBuilder {
	b.WriteMask = writeMask
	return b
}

func (b *_ReferenceTypeAttributesBuilder) WithUserWriteMask(userWriteMask uint32) ReferenceTypeAttributesBuilder {
	b.UserWriteMask = userWriteMask
	return b
}

func (b *_ReferenceTypeAttributesBuilder) WithSymmetric(symmetric bool) ReferenceTypeAttributesBuilder {
	b.Symmetric = symmetric
	return b
}

func (b *_ReferenceTypeAttributesBuilder) WithIsAbstract(isAbstract bool) ReferenceTypeAttributesBuilder {
	b.IsAbstract = isAbstract
	return b
}

func (b *_ReferenceTypeAttributesBuilder) WithInverseName(inverseName LocalizedText) ReferenceTypeAttributesBuilder {
	b.InverseName = inverseName
	return b
}

func (b *_ReferenceTypeAttributesBuilder) WithInverseNameBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) ReferenceTypeAttributesBuilder {
	builder := builderSupplier(b.InverseName.CreateLocalizedTextBuilder())
	var err error
	b.InverseName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_ReferenceTypeAttributesBuilder) Build() (ReferenceTypeAttributes, error) {
	if b.DisplayName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'displayName' not set"))
	}
	if b.Description == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'description' not set"))
	}
	if b.InverseName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'inverseName' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ReferenceTypeAttributes.deepCopy(), nil
}

func (b *_ReferenceTypeAttributesBuilder) MustBuild() ReferenceTypeAttributes {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ReferenceTypeAttributesBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ReferenceTypeAttributesBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ReferenceTypeAttributesBuilder) DeepCopy() any {
	_copy := b.CreateReferenceTypeAttributesBuilder().(*_ReferenceTypeAttributesBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateReferenceTypeAttributesBuilder creates a ReferenceTypeAttributesBuilder
func (b *_ReferenceTypeAttributes) CreateReferenceTypeAttributesBuilder() ReferenceTypeAttributesBuilder {
	if b == nil {
		return NewReferenceTypeAttributesBuilder()
	}
	return &_ReferenceTypeAttributesBuilder{_ReferenceTypeAttributes: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ReferenceTypeAttributes) GetExtensionId() int32 {
	return int32(369)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ReferenceTypeAttributes) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ReferenceTypeAttributes) GetSpecifiedAttributes() uint32 {
	return m.SpecifiedAttributes
}

func (m *_ReferenceTypeAttributes) GetDisplayName() LocalizedText {
	return m.DisplayName
}

func (m *_ReferenceTypeAttributes) GetDescription() LocalizedText {
	return m.Description
}

func (m *_ReferenceTypeAttributes) GetWriteMask() uint32 {
	return m.WriteMask
}

func (m *_ReferenceTypeAttributes) GetUserWriteMask() uint32 {
	return m.UserWriteMask
}

func (m *_ReferenceTypeAttributes) GetSymmetric() bool {
	return m.Symmetric
}

func (m *_ReferenceTypeAttributes) GetIsAbstract() bool {
	return m.IsAbstract
}

func (m *_ReferenceTypeAttributes) GetInverseName() LocalizedText {
	return m.InverseName
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastReferenceTypeAttributes(structType any) ReferenceTypeAttributes {
	if casted, ok := structType.(ReferenceTypeAttributes); ok {
		return casted
	}
	if casted, ok := structType.(*ReferenceTypeAttributes); ok {
		return *casted
	}
	return nil
}

func (m *_ReferenceTypeAttributes) GetTypeName() string {
	return "ReferenceTypeAttributes"
}

func (m *_ReferenceTypeAttributes) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (specifiedAttributes)
	lengthInBits += 32

	// Simple field (displayName)
	lengthInBits += m.DisplayName.GetLengthInBits(ctx)

	// Simple field (description)
	lengthInBits += m.Description.GetLengthInBits(ctx)

	// Simple field (writeMask)
	lengthInBits += 32

	// Simple field (userWriteMask)
	lengthInBits += 32

	// Reserved Field (reserved)
	lengthInBits += 6

	// Simple field (symmetric)
	lengthInBits += 1

	// Simple field (isAbstract)
	lengthInBits += 1

	// Simple field (inverseName)
	lengthInBits += m.InverseName.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ReferenceTypeAttributes) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ReferenceTypeAttributes) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__referenceTypeAttributes ReferenceTypeAttributes, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ReferenceTypeAttributes"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ReferenceTypeAttributes")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	specifiedAttributes, err := ReadSimpleField(ctx, "specifiedAttributes", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'specifiedAttributes' field"))
	}
	m.SpecifiedAttributes = specifiedAttributes

	displayName, err := ReadSimpleField[LocalizedText](ctx, "displayName", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'displayName' field"))
	}
	m.DisplayName = displayName

	description, err := ReadSimpleField[LocalizedText](ctx, "description", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'description' field"))
	}
	m.Description = description

	writeMask, err := ReadSimpleField(ctx, "writeMask", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writeMask' field"))
	}
	m.WriteMask = writeMask

	userWriteMask, err := ReadSimpleField(ctx, "userWriteMask", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userWriteMask' field"))
	}
	m.UserWriteMask = userWriteMask

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(6)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	symmetric, err := ReadSimpleField(ctx, "symmetric", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'symmetric' field"))
	}
	m.Symmetric = symmetric

	isAbstract, err := ReadSimpleField(ctx, "isAbstract", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isAbstract' field"))
	}
	m.IsAbstract = isAbstract

	inverseName, err := ReadSimpleField[LocalizedText](ctx, "inverseName", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'inverseName' field"))
	}
	m.InverseName = inverseName

	if closeErr := readBuffer.CloseContext("ReferenceTypeAttributes"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ReferenceTypeAttributes")
	}

	return m, nil
}

func (m *_ReferenceTypeAttributes) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ReferenceTypeAttributes) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ReferenceTypeAttributes"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ReferenceTypeAttributes")
		}

		if err := WriteSimpleField[uint32](ctx, "specifiedAttributes", m.GetSpecifiedAttributes(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'specifiedAttributes' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "displayName", m.GetDisplayName(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'displayName' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "description", m.GetDescription(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'description' field")
		}

		if err := WriteSimpleField[uint32](ctx, "writeMask", m.GetWriteMask(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'writeMask' field")
		}

		if err := WriteSimpleField[uint32](ctx, "userWriteMask", m.GetUserWriteMask(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'userWriteMask' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 6)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "symmetric", m.GetSymmetric(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'symmetric' field")
		}

		if err := WriteSimpleField[bool](ctx, "isAbstract", m.GetIsAbstract(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'isAbstract' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "inverseName", m.GetInverseName(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'inverseName' field")
		}

		if popErr := writeBuffer.PopContext("ReferenceTypeAttributes"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ReferenceTypeAttributes")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ReferenceTypeAttributes) IsReferenceTypeAttributes() {}

func (m *_ReferenceTypeAttributes) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ReferenceTypeAttributes) deepCopy() *_ReferenceTypeAttributes {
	if m == nil {
		return nil
	}
	_ReferenceTypeAttributesCopy := &_ReferenceTypeAttributes{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.SpecifiedAttributes,
		utils.DeepCopy[LocalizedText](m.DisplayName),
		utils.DeepCopy[LocalizedText](m.Description),
		m.WriteMask,
		m.UserWriteMask,
		m.Symmetric,
		m.IsAbstract,
		utils.DeepCopy[LocalizedText](m.InverseName),
		m.reservedField0,
	}
	_ReferenceTypeAttributesCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ReferenceTypeAttributesCopy
}

func (m *_ReferenceTypeAttributes) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
