/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// EndpointUrlListDataType is the corresponding interface of EndpointUrlListDataType
type EndpointUrlListDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetEndpointUrlList returns EndpointUrlList (property field)
	GetEndpointUrlList() []PascalString
	// IsEndpointUrlListDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsEndpointUrlListDataType()
	// CreateBuilder creates a EndpointUrlListDataTypeBuilder
	CreateEndpointUrlListDataTypeBuilder() EndpointUrlListDataTypeBuilder
}

// _EndpointUrlListDataType is the data-structure of this message
type _EndpointUrlListDataType struct {
	ExtensionObjectDefinitionContract
	EndpointUrlList []PascalString
}

var _ EndpointUrlListDataType = (*_EndpointUrlListDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_EndpointUrlListDataType)(nil)

// NewEndpointUrlListDataType factory function for _EndpointUrlListDataType
func NewEndpointUrlListDataType(endpointUrlList []PascalString) *_EndpointUrlListDataType {
	_result := &_EndpointUrlListDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		EndpointUrlList:                   endpointUrlList,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// EndpointUrlListDataTypeBuilder is a builder for EndpointUrlListDataType
type EndpointUrlListDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(endpointUrlList []PascalString) EndpointUrlListDataTypeBuilder
	// WithEndpointUrlList adds EndpointUrlList (property field)
	WithEndpointUrlList(...PascalString) EndpointUrlListDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the EndpointUrlListDataType or returns an error if something is wrong
	Build() (EndpointUrlListDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() EndpointUrlListDataType
}

// NewEndpointUrlListDataTypeBuilder() creates a EndpointUrlListDataTypeBuilder
func NewEndpointUrlListDataTypeBuilder() EndpointUrlListDataTypeBuilder {
	return &_EndpointUrlListDataTypeBuilder{_EndpointUrlListDataType: new(_EndpointUrlListDataType)}
}

type _EndpointUrlListDataTypeBuilder struct {
	*_EndpointUrlListDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (EndpointUrlListDataTypeBuilder) = (*_EndpointUrlListDataTypeBuilder)(nil)

func (b *_EndpointUrlListDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._EndpointUrlListDataType
}

func (b *_EndpointUrlListDataTypeBuilder) WithMandatoryFields(endpointUrlList []PascalString) EndpointUrlListDataTypeBuilder {
	return b.WithEndpointUrlList(endpointUrlList...)
}

func (b *_EndpointUrlListDataTypeBuilder) WithEndpointUrlList(endpointUrlList ...PascalString) EndpointUrlListDataTypeBuilder {
	b.EndpointUrlList = endpointUrlList
	return b
}

func (b *_EndpointUrlListDataTypeBuilder) Build() (EndpointUrlListDataType, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._EndpointUrlListDataType.deepCopy(), nil
}

func (b *_EndpointUrlListDataTypeBuilder) MustBuild() EndpointUrlListDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_EndpointUrlListDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_EndpointUrlListDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_EndpointUrlListDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateEndpointUrlListDataTypeBuilder().(*_EndpointUrlListDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateEndpointUrlListDataTypeBuilder creates a EndpointUrlListDataTypeBuilder
func (b *_EndpointUrlListDataType) CreateEndpointUrlListDataTypeBuilder() EndpointUrlListDataTypeBuilder {
	if b == nil {
		return NewEndpointUrlListDataTypeBuilder()
	}
	return &_EndpointUrlListDataTypeBuilder{_EndpointUrlListDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_EndpointUrlListDataType) GetExtensionId() int32 {
	return int32(11945)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_EndpointUrlListDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_EndpointUrlListDataType) GetEndpointUrlList() []PascalString {
	return m.EndpointUrlList
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastEndpointUrlListDataType(structType any) EndpointUrlListDataType {
	if casted, ok := structType.(EndpointUrlListDataType); ok {
		return casted
	}
	if casted, ok := structType.(*EndpointUrlListDataType); ok {
		return *casted
	}
	return nil
}

func (m *_EndpointUrlListDataType) GetTypeName() string {
	return "EndpointUrlListDataType"
}

func (m *_EndpointUrlListDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Implicit Field (noOfEndpointUrlList)
	lengthInBits += 32

	// Array field
	if len(m.EndpointUrlList) > 0 {
		for _curItem, element := range m.EndpointUrlList {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.EndpointUrlList), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_EndpointUrlListDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_EndpointUrlListDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__endpointUrlListDataType EndpointUrlListDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("EndpointUrlListDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for EndpointUrlListDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	noOfEndpointUrlList, err := ReadImplicitField[int32](ctx, "noOfEndpointUrlList", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfEndpointUrlList' field"))
	}
	_ = noOfEndpointUrlList

	endpointUrlList, err := ReadCountArrayField[PascalString](ctx, "endpointUrlList", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfEndpointUrlList))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'endpointUrlList' field"))
	}
	m.EndpointUrlList = endpointUrlList

	if closeErr := readBuffer.CloseContext("EndpointUrlListDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for EndpointUrlListDataType")
	}

	return m, nil
}

func (m *_EndpointUrlListDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_EndpointUrlListDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("EndpointUrlListDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for EndpointUrlListDataType")
		}
		noOfEndpointUrlList := int32(utils.InlineIf(bool((m.GetEndpointUrlList()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetEndpointUrlList()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfEndpointUrlList", noOfEndpointUrlList, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfEndpointUrlList' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "endpointUrlList", m.GetEndpointUrlList(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'endpointUrlList' field")
		}

		if popErr := writeBuffer.PopContext("EndpointUrlListDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for EndpointUrlListDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_EndpointUrlListDataType) IsEndpointUrlListDataType() {}

func (m *_EndpointUrlListDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_EndpointUrlListDataType) deepCopy() *_EndpointUrlListDataType {
	if m == nil {
		return nil
	}
	_EndpointUrlListDataTypeCopy := &_EndpointUrlListDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopySlice[PascalString, PascalString](m.EndpointUrlList),
	}
	_EndpointUrlListDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _EndpointUrlListDataTypeCopy
}

func (m *_EndpointUrlListDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
