/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CertificateGroupDataType is the corresponding interface of CertificateGroupDataType
type CertificateGroupDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetName returns Name (property field)
	GetName() PascalString
	// GetRecordProperties returns RecordProperties (property field)
	GetRecordProperties() []KeyValuePair
	// GetPurpose returns Purpose (property field)
	GetPurpose() NodeId
	// GetCertificateTypes returns CertificateTypes (property field)
	GetCertificateTypes() []NodeId
	// GetIsCertificateAssigned returns IsCertificateAssigned (property field)
	GetIsCertificateAssigned() []bool
	// GetValidationOptions returns ValidationOptions (property field)
	GetValidationOptions() TrustListValidationOptions
	// IsCertificateGroupDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCertificateGroupDataType()
	// CreateBuilder creates a CertificateGroupDataTypeBuilder
	CreateCertificateGroupDataTypeBuilder() CertificateGroupDataTypeBuilder
}

// _CertificateGroupDataType is the data-structure of this message
type _CertificateGroupDataType struct {
	ExtensionObjectDefinitionContract
	Name                  PascalString
	RecordProperties      []KeyValuePair
	Purpose               NodeId
	CertificateTypes      []NodeId
	IsCertificateAssigned []bool
	ValidationOptions     TrustListValidationOptions
	// Reserved Fields
	reservedField0 *uint8
}

var _ CertificateGroupDataType = (*_CertificateGroupDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_CertificateGroupDataType)(nil)

// NewCertificateGroupDataType factory function for _CertificateGroupDataType
func NewCertificateGroupDataType(name PascalString, recordProperties []KeyValuePair, purpose NodeId, certificateTypes []NodeId, isCertificateAssigned []bool, validationOptions TrustListValidationOptions) *_CertificateGroupDataType {
	if name == nil {
		panic("name of type PascalString for CertificateGroupDataType must not be nil")
	}
	if purpose == nil {
		panic("purpose of type NodeId for CertificateGroupDataType must not be nil")
	}
	_result := &_CertificateGroupDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Name:                              name,
		RecordProperties:                  recordProperties,
		Purpose:                           purpose,
		CertificateTypes:                  certificateTypes,
		IsCertificateAssigned:             isCertificateAssigned,
		ValidationOptions:                 validationOptions,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CertificateGroupDataTypeBuilder is a builder for CertificateGroupDataType
type CertificateGroupDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(name PascalString, recordProperties []KeyValuePair, purpose NodeId, certificateTypes []NodeId, isCertificateAssigned []bool, validationOptions TrustListValidationOptions) CertificateGroupDataTypeBuilder
	// WithName adds Name (property field)
	WithName(PascalString) CertificateGroupDataTypeBuilder
	// WithNameBuilder adds Name (property field) which is build by the builder
	WithNameBuilder(func(PascalStringBuilder) PascalStringBuilder) CertificateGroupDataTypeBuilder
	// WithRecordProperties adds RecordProperties (property field)
	WithRecordProperties(...KeyValuePair) CertificateGroupDataTypeBuilder
	// WithPurpose adds Purpose (property field)
	WithPurpose(NodeId) CertificateGroupDataTypeBuilder
	// WithPurposeBuilder adds Purpose (property field) which is build by the builder
	WithPurposeBuilder(func(NodeIdBuilder) NodeIdBuilder) CertificateGroupDataTypeBuilder
	// WithCertificateTypes adds CertificateTypes (property field)
	WithCertificateTypes(...NodeId) CertificateGroupDataTypeBuilder
	// WithIsCertificateAssigned adds IsCertificateAssigned (property field)
	WithIsCertificateAssigned(...bool) CertificateGroupDataTypeBuilder
	// WithValidationOptions adds ValidationOptions (property field)
	WithValidationOptions(TrustListValidationOptions) CertificateGroupDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the CertificateGroupDataType or returns an error if something is wrong
	Build() (CertificateGroupDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CertificateGroupDataType
}

// NewCertificateGroupDataTypeBuilder() creates a CertificateGroupDataTypeBuilder
func NewCertificateGroupDataTypeBuilder() CertificateGroupDataTypeBuilder {
	return &_CertificateGroupDataTypeBuilder{_CertificateGroupDataType: new(_CertificateGroupDataType)}
}

type _CertificateGroupDataTypeBuilder struct {
	*_CertificateGroupDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (CertificateGroupDataTypeBuilder) = (*_CertificateGroupDataTypeBuilder)(nil)

func (b *_CertificateGroupDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._CertificateGroupDataType
}

func (b *_CertificateGroupDataTypeBuilder) WithMandatoryFields(name PascalString, recordProperties []KeyValuePair, purpose NodeId, certificateTypes []NodeId, isCertificateAssigned []bool, validationOptions TrustListValidationOptions) CertificateGroupDataTypeBuilder {
	return b.WithName(name).WithRecordProperties(recordProperties...).WithPurpose(purpose).WithCertificateTypes(certificateTypes...).WithIsCertificateAssigned(isCertificateAssigned...).WithValidationOptions(validationOptions)
}

func (b *_CertificateGroupDataTypeBuilder) WithName(name PascalString) CertificateGroupDataTypeBuilder {
	b.Name = name
	return b
}

func (b *_CertificateGroupDataTypeBuilder) WithNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) CertificateGroupDataTypeBuilder {
	builder := builderSupplier(b.Name.CreatePascalStringBuilder())
	var err error
	b.Name, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_CertificateGroupDataTypeBuilder) WithRecordProperties(recordProperties ...KeyValuePair) CertificateGroupDataTypeBuilder {
	b.RecordProperties = recordProperties
	return b
}

func (b *_CertificateGroupDataTypeBuilder) WithPurpose(purpose NodeId) CertificateGroupDataTypeBuilder {
	b.Purpose = purpose
	return b
}

func (b *_CertificateGroupDataTypeBuilder) WithPurposeBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) CertificateGroupDataTypeBuilder {
	builder := builderSupplier(b.Purpose.CreateNodeIdBuilder())
	var err error
	b.Purpose, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_CertificateGroupDataTypeBuilder) WithCertificateTypes(certificateTypes ...NodeId) CertificateGroupDataTypeBuilder {
	b.CertificateTypes = certificateTypes
	return b
}

func (b *_CertificateGroupDataTypeBuilder) WithIsCertificateAssigned(isCertificateAssigned ...bool) CertificateGroupDataTypeBuilder {
	b.IsCertificateAssigned = isCertificateAssigned
	return b
}

func (b *_CertificateGroupDataTypeBuilder) WithValidationOptions(validationOptions TrustListValidationOptions) CertificateGroupDataTypeBuilder {
	b.ValidationOptions = validationOptions
	return b
}

func (b *_CertificateGroupDataTypeBuilder) Build() (CertificateGroupDataType, error) {
	if b.Name == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'name' not set"))
	}
	if b.Purpose == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'purpose' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._CertificateGroupDataType.deepCopy(), nil
}

func (b *_CertificateGroupDataTypeBuilder) MustBuild() CertificateGroupDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CertificateGroupDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_CertificateGroupDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_CertificateGroupDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateCertificateGroupDataTypeBuilder().(*_CertificateGroupDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateCertificateGroupDataTypeBuilder creates a CertificateGroupDataTypeBuilder
func (b *_CertificateGroupDataType) CreateCertificateGroupDataTypeBuilder() CertificateGroupDataTypeBuilder {
	if b == nil {
		return NewCertificateGroupDataTypeBuilder()
	}
	return &_CertificateGroupDataTypeBuilder{_CertificateGroupDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_CertificateGroupDataType) GetExtensionId() int32 {
	return int32(15438)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CertificateGroupDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CertificateGroupDataType) GetName() PascalString {
	return m.Name
}

func (m *_CertificateGroupDataType) GetRecordProperties() []KeyValuePair {
	return m.RecordProperties
}

func (m *_CertificateGroupDataType) GetPurpose() NodeId {
	return m.Purpose
}

func (m *_CertificateGroupDataType) GetCertificateTypes() []NodeId {
	return m.CertificateTypes
}

func (m *_CertificateGroupDataType) GetIsCertificateAssigned() []bool {
	return m.IsCertificateAssigned
}

func (m *_CertificateGroupDataType) GetValidationOptions() TrustListValidationOptions {
	return m.ValidationOptions
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCertificateGroupDataType(structType any) CertificateGroupDataType {
	if casted, ok := structType.(CertificateGroupDataType); ok {
		return casted
	}
	if casted, ok := structType.(*CertificateGroupDataType); ok {
		return *casted
	}
	return nil
}

func (m *_CertificateGroupDataType) GetTypeName() string {
	return "CertificateGroupDataType"
}

func (m *_CertificateGroupDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	// Implicit Field (noOfRecordProperties)
	lengthInBits += 32

	// Array field
	if len(m.RecordProperties) > 0 {
		for _curItem, element := range m.RecordProperties {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.RecordProperties), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (purpose)
	lengthInBits += m.Purpose.GetLengthInBits(ctx)

	// Implicit Field (noOfCertificateTypes)
	lengthInBits += 32

	// Array field
	if len(m.CertificateTypes) > 0 {
		for _curItem, element := range m.CertificateTypes {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.CertificateTypes), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfIsCertificateAssigned)
	lengthInBits += 32

	// Reserved Field (reserved)
	lengthInBits += 7

	// Array field
	if len(m.IsCertificateAssigned) > 0 {
		lengthInBits += 1 * uint16(len(m.IsCertificateAssigned))
	}

	// Simple field (validationOptions)
	lengthInBits += 32

	return lengthInBits
}

func (m *_CertificateGroupDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_CertificateGroupDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__certificateGroupDataType CertificateGroupDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CertificateGroupDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CertificateGroupDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	name, err := ReadSimpleField[PascalString](ctx, "name", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'name' field"))
	}
	m.Name = name

	noOfRecordProperties, err := ReadImplicitField[int32](ctx, "noOfRecordProperties", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfRecordProperties' field"))
	}
	_ = noOfRecordProperties

	recordProperties, err := ReadCountArrayField[KeyValuePair](ctx, "recordProperties", ReadComplex[KeyValuePair](ExtensionObjectDefinitionParseWithBufferProducer[KeyValuePair]((int32)(int32(14535))), readBuffer), uint64(noOfRecordProperties))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'recordProperties' field"))
	}
	m.RecordProperties = recordProperties

	purpose, err := ReadSimpleField[NodeId](ctx, "purpose", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'purpose' field"))
	}
	m.Purpose = purpose

	noOfCertificateTypes, err := ReadImplicitField[int32](ctx, "noOfCertificateTypes", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfCertificateTypes' field"))
	}
	_ = noOfCertificateTypes

	certificateTypes, err := ReadCountArrayField[NodeId](ctx, "certificateTypes", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer), uint64(noOfCertificateTypes))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'certificateTypes' field"))
	}
	m.CertificateTypes = certificateTypes

	noOfIsCertificateAssigned, err := ReadImplicitField[int32](ctx, "noOfIsCertificateAssigned", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfIsCertificateAssigned' field"))
	}
	_ = noOfIsCertificateAssigned

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	isCertificateAssigned, err := ReadCountArrayField[bool](ctx, "isCertificateAssigned", ReadBoolean(readBuffer), uint64(noOfIsCertificateAssigned))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isCertificateAssigned' field"))
	}
	m.IsCertificateAssigned = isCertificateAssigned

	validationOptions, err := ReadEnumField[TrustListValidationOptions](ctx, "validationOptions", "TrustListValidationOptions", ReadEnum(TrustListValidationOptionsByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'validationOptions' field"))
	}
	m.ValidationOptions = validationOptions

	if closeErr := readBuffer.CloseContext("CertificateGroupDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CertificateGroupDataType")
	}

	return m, nil
}

func (m *_CertificateGroupDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CertificateGroupDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CertificateGroupDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CertificateGroupDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "name", m.GetName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'name' field")
		}
		noOfRecordProperties := int32(utils.InlineIf(bool((m.GetRecordProperties()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetRecordProperties()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfRecordProperties", noOfRecordProperties, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfRecordProperties' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "recordProperties", m.GetRecordProperties(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'recordProperties' field")
		}

		if err := WriteSimpleField[NodeId](ctx, "purpose", m.GetPurpose(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'purpose' field")
		}
		noOfCertificateTypes := int32(utils.InlineIf(bool((m.GetCertificateTypes()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetCertificateTypes()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfCertificateTypes", noOfCertificateTypes, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfCertificateTypes' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "certificateTypes", m.GetCertificateTypes(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'certificateTypes' field")
		}
		noOfIsCertificateAssigned := int32(utils.InlineIf(bool((m.GetIsCertificateAssigned()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetIsCertificateAssigned()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfIsCertificateAssigned", noOfIsCertificateAssigned, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfIsCertificateAssigned' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleTypeArrayField(ctx, "isCertificateAssigned", m.GetIsCertificateAssigned(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'isCertificateAssigned' field")
		}

		if err := WriteSimpleEnumField[TrustListValidationOptions](ctx, "validationOptions", "TrustListValidationOptions", m.GetValidationOptions(), WriteEnum[TrustListValidationOptions, uint32](TrustListValidationOptions.GetValue, TrustListValidationOptions.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'validationOptions' field")
		}

		if popErr := writeBuffer.PopContext("CertificateGroupDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CertificateGroupDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CertificateGroupDataType) IsCertificateGroupDataType() {}

func (m *_CertificateGroupDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CertificateGroupDataType) deepCopy() *_CertificateGroupDataType {
	if m == nil {
		return nil
	}
	_CertificateGroupDataTypeCopy := &_CertificateGroupDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.Name),
		utils.DeepCopySlice[KeyValuePair, KeyValuePair](m.RecordProperties),
		utils.DeepCopy[NodeId](m.Purpose),
		utils.DeepCopySlice[NodeId, NodeId](m.CertificateTypes),
		utils.DeepCopySlice[bool, bool](m.IsCertificateAssigned),
		m.ValidationOptions,
		m.reservedField0,
	}
	_CertificateGroupDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _CertificateGroupDataTypeCopy
}

func (m *_CertificateGroupDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
