/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// KnxAddress is the corresponding interface of KnxAddress
type KnxAddress interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetMainGroup returns MainGroup (property field)
	GetMainGroup() uint8
	// GetMiddleGroup returns MiddleGroup (property field)
	GetMiddleGroup() uint8
	// GetSubGroup returns SubGroup (property field)
	GetSubGroup() uint8
	// IsKnxAddress is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsKnxAddress()
	// CreateBuilder creates a KnxAddressBuilder
	CreateKnxAddressBuilder() KnxAddressBuilder
}

// _KnxAddress is the data-structure of this message
type _KnxAddress struct {
	MainGroup   uint8
	MiddleGroup uint8
	SubGroup    uint8
}

var _ KnxAddress = (*_KnxAddress)(nil)

// NewKnxAddress factory function for _KnxAddress
func NewKnxAddress(mainGroup uint8, middleGroup uint8, subGroup uint8) *_KnxAddress {
	return &_KnxAddress{MainGroup: mainGroup, MiddleGroup: middleGroup, SubGroup: subGroup}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// KnxAddressBuilder is a builder for KnxAddress
type KnxAddressBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(mainGroup uint8, middleGroup uint8, subGroup uint8) KnxAddressBuilder
	// WithMainGroup adds MainGroup (property field)
	WithMainGroup(uint8) KnxAddressBuilder
	// WithMiddleGroup adds MiddleGroup (property field)
	WithMiddleGroup(uint8) KnxAddressBuilder
	// WithSubGroup adds SubGroup (property field)
	WithSubGroup(uint8) KnxAddressBuilder
	// Build builds the KnxAddress or returns an error if something is wrong
	Build() (KnxAddress, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() KnxAddress
}

// NewKnxAddressBuilder() creates a KnxAddressBuilder
func NewKnxAddressBuilder() KnxAddressBuilder {
	return &_KnxAddressBuilder{_KnxAddress: new(_KnxAddress)}
}

type _KnxAddressBuilder struct {
	*_KnxAddress

	collectedErr []error
}

var _ (KnxAddressBuilder) = (*_KnxAddressBuilder)(nil)

func (b *_KnxAddressBuilder) WithMandatoryFields(mainGroup uint8, middleGroup uint8, subGroup uint8) KnxAddressBuilder {
	return b.WithMainGroup(mainGroup).WithMiddleGroup(middleGroup).WithSubGroup(subGroup)
}

func (b *_KnxAddressBuilder) WithMainGroup(mainGroup uint8) KnxAddressBuilder {
	b.MainGroup = mainGroup
	return b
}

func (b *_KnxAddressBuilder) WithMiddleGroup(middleGroup uint8) KnxAddressBuilder {
	b.MiddleGroup = middleGroup
	return b
}

func (b *_KnxAddressBuilder) WithSubGroup(subGroup uint8) KnxAddressBuilder {
	b.SubGroup = subGroup
	return b
}

func (b *_KnxAddressBuilder) Build() (KnxAddress, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._KnxAddress.deepCopy(), nil
}

func (b *_KnxAddressBuilder) MustBuild() KnxAddress {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_KnxAddressBuilder) DeepCopy() any {
	_copy := b.CreateKnxAddressBuilder().(*_KnxAddressBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateKnxAddressBuilder creates a KnxAddressBuilder
func (b *_KnxAddress) CreateKnxAddressBuilder() KnxAddressBuilder {
	if b == nil {
		return NewKnxAddressBuilder()
	}
	return &_KnxAddressBuilder{_KnxAddress: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_KnxAddress) GetMainGroup() uint8 {
	return m.MainGroup
}

func (m *_KnxAddress) GetMiddleGroup() uint8 {
	return m.MiddleGroup
}

func (m *_KnxAddress) GetSubGroup() uint8 {
	return m.SubGroup
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastKnxAddress(structType any) KnxAddress {
	if casted, ok := structType.(KnxAddress); ok {
		return casted
	}
	if casted, ok := structType.(*KnxAddress); ok {
		return *casted
	}
	return nil
}

func (m *_KnxAddress) GetTypeName() string {
	return "KnxAddress"
}

func (m *_KnxAddress) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (mainGroup)
	lengthInBits += 4

	// Simple field (middleGroup)
	lengthInBits += 4

	// Simple field (subGroup)
	lengthInBits += 8

	return lengthInBits
}

func (m *_KnxAddress) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func KnxAddressParse(ctx context.Context, theBytes []byte) (KnxAddress, error) {
	return KnxAddressParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func KnxAddressParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (KnxAddress, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (KnxAddress, error) {
		return KnxAddressParseWithBuffer(ctx, readBuffer)
	}
}

func KnxAddressParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (KnxAddress, error) {
	v, err := (&_KnxAddress{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_KnxAddress) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__knxAddress KnxAddress, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("KnxAddress"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for KnxAddress")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	mainGroup, err := ReadSimpleField(ctx, "mainGroup", ReadUnsignedByte(readBuffer, uint8(4)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'mainGroup' field"))
	}
	m.MainGroup = mainGroup

	middleGroup, err := ReadSimpleField(ctx, "middleGroup", ReadUnsignedByte(readBuffer, uint8(4)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'middleGroup' field"))
	}
	m.MiddleGroup = middleGroup

	subGroup, err := ReadSimpleField(ctx, "subGroup", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'subGroup' field"))
	}
	m.SubGroup = subGroup

	if closeErr := readBuffer.CloseContext("KnxAddress"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for KnxAddress")
	}

	return m, nil
}

func (m *_KnxAddress) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_KnxAddress) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("KnxAddress"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for KnxAddress")
	}

	if err := WriteSimpleField[uint8](ctx, "mainGroup", m.GetMainGroup(), WriteUnsignedByte(writeBuffer, 4)); err != nil {
		return errors.Wrap(err, "Error serializing 'mainGroup' field")
	}

	if err := WriteSimpleField[uint8](ctx, "middleGroup", m.GetMiddleGroup(), WriteUnsignedByte(writeBuffer, 4)); err != nil {
		return errors.Wrap(err, "Error serializing 'middleGroup' field")
	}

	if err := WriteSimpleField[uint8](ctx, "subGroup", m.GetSubGroup(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'subGroup' field")
	}

	if popErr := writeBuffer.PopContext("KnxAddress"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for KnxAddress")
	}
	return nil
}

func (m *_KnxAddress) IsKnxAddress() {}

func (m *_KnxAddress) DeepCopy() any {
	return m.deepCopy()
}

func (m *_KnxAddress) deepCopy() *_KnxAddress {
	if m == nil {
		return nil
	}
	_KnxAddressCopy := &_KnxAddress{
		m.MainGroup,
		m.MiddleGroup,
		m.SubGroup,
	}
	return _KnxAddressCopy
}

func (m *_KnxAddress) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
