/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TriggerControlDataTriggerMax is the corresponding interface of TriggerControlDataTriggerMax
type TriggerControlDataTriggerMax interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	TriggerControlData
	// IsTriggerControlDataTriggerMax is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTriggerControlDataTriggerMax()
	// CreateBuilder creates a TriggerControlDataTriggerMaxBuilder
	CreateTriggerControlDataTriggerMaxBuilder() TriggerControlDataTriggerMaxBuilder
}

// _TriggerControlDataTriggerMax is the data-structure of this message
type _TriggerControlDataTriggerMax struct {
	TriggerControlDataContract
}

var _ TriggerControlDataTriggerMax = (*_TriggerControlDataTriggerMax)(nil)
var _ TriggerControlDataRequirements = (*_TriggerControlDataTriggerMax)(nil)

// NewTriggerControlDataTriggerMax factory function for _TriggerControlDataTriggerMax
func NewTriggerControlDataTriggerMax(commandTypeContainer TriggerControlCommandTypeContainer, triggerGroup byte) *_TriggerControlDataTriggerMax {
	_result := &_TriggerControlDataTriggerMax{
		TriggerControlDataContract: NewTriggerControlData(commandTypeContainer, triggerGroup),
	}
	_result.TriggerControlDataContract.(*_TriggerControlData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TriggerControlDataTriggerMaxBuilder is a builder for TriggerControlDataTriggerMax
type TriggerControlDataTriggerMaxBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() TriggerControlDataTriggerMaxBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() TriggerControlDataBuilder
	// Build builds the TriggerControlDataTriggerMax or returns an error if something is wrong
	Build() (TriggerControlDataTriggerMax, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TriggerControlDataTriggerMax
}

// NewTriggerControlDataTriggerMaxBuilder() creates a TriggerControlDataTriggerMaxBuilder
func NewTriggerControlDataTriggerMaxBuilder() TriggerControlDataTriggerMaxBuilder {
	return &_TriggerControlDataTriggerMaxBuilder{_TriggerControlDataTriggerMax: new(_TriggerControlDataTriggerMax)}
}

type _TriggerControlDataTriggerMaxBuilder struct {
	*_TriggerControlDataTriggerMax

	parentBuilder *_TriggerControlDataBuilder

	collectedErr []error
}

var _ (TriggerControlDataTriggerMaxBuilder) = (*_TriggerControlDataTriggerMaxBuilder)(nil)

func (b *_TriggerControlDataTriggerMaxBuilder) setParent(contract TriggerControlDataContract) {
	b.TriggerControlDataContract = contract
	contract.(*_TriggerControlData)._SubType = b._TriggerControlDataTriggerMax
}

func (b *_TriggerControlDataTriggerMaxBuilder) WithMandatoryFields() TriggerControlDataTriggerMaxBuilder {
	return b
}

func (b *_TriggerControlDataTriggerMaxBuilder) Build() (TriggerControlDataTriggerMax, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._TriggerControlDataTriggerMax.deepCopy(), nil
}

func (b *_TriggerControlDataTriggerMaxBuilder) MustBuild() TriggerControlDataTriggerMax {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TriggerControlDataTriggerMaxBuilder) Done() TriggerControlDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewTriggerControlDataBuilder().(*_TriggerControlDataBuilder)
	}
	return b.parentBuilder
}

func (b *_TriggerControlDataTriggerMaxBuilder) buildForTriggerControlData() (TriggerControlData, error) {
	return b.Build()
}

func (b *_TriggerControlDataTriggerMaxBuilder) DeepCopy() any {
	_copy := b.CreateTriggerControlDataTriggerMaxBuilder().(*_TriggerControlDataTriggerMaxBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateTriggerControlDataTriggerMaxBuilder creates a TriggerControlDataTriggerMaxBuilder
func (b *_TriggerControlDataTriggerMax) CreateTriggerControlDataTriggerMaxBuilder() TriggerControlDataTriggerMaxBuilder {
	if b == nil {
		return NewTriggerControlDataTriggerMaxBuilder()
	}
	return &_TriggerControlDataTriggerMaxBuilder{_TriggerControlDataTriggerMax: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_TriggerControlDataTriggerMax) GetParent() TriggerControlDataContract {
	return m.TriggerControlDataContract
}

// Deprecated: use the interface for direct cast
func CastTriggerControlDataTriggerMax(structType any) TriggerControlDataTriggerMax {
	if casted, ok := structType.(TriggerControlDataTriggerMax); ok {
		return casted
	}
	if casted, ok := structType.(*TriggerControlDataTriggerMax); ok {
		return *casted
	}
	return nil
}

func (m *_TriggerControlDataTriggerMax) GetTypeName() string {
	return "TriggerControlDataTriggerMax"
}

func (m *_TriggerControlDataTriggerMax) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.TriggerControlDataContract.(*_TriggerControlData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_TriggerControlDataTriggerMax) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_TriggerControlDataTriggerMax) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_TriggerControlData) (__triggerControlDataTriggerMax TriggerControlDataTriggerMax, err error) {
	m.TriggerControlDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TriggerControlDataTriggerMax"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TriggerControlDataTriggerMax")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("TriggerControlDataTriggerMax"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TriggerControlDataTriggerMax")
	}

	return m, nil
}

func (m *_TriggerControlDataTriggerMax) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TriggerControlDataTriggerMax) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("TriggerControlDataTriggerMax"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for TriggerControlDataTriggerMax")
		}

		if popErr := writeBuffer.PopContext("TriggerControlDataTriggerMax"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for TriggerControlDataTriggerMax")
		}
		return nil
	}
	return m.TriggerControlDataContract.(*_TriggerControlData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_TriggerControlDataTriggerMax) IsTriggerControlDataTriggerMax() {}

func (m *_TriggerControlDataTriggerMax) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TriggerControlDataTriggerMax) deepCopy() *_TriggerControlDataTriggerMax {
	if m == nil {
		return nil
	}
	_TriggerControlDataTriggerMaxCopy := &_TriggerControlDataTriggerMax{
		m.TriggerControlDataContract.(*_TriggerControlData).deepCopy(),
	}
	_TriggerControlDataTriggerMaxCopy.TriggerControlDataContract.(*_TriggerControlData)._SubType = m
	return _TriggerControlDataTriggerMaxCopy
}

func (m *_TriggerControlDataTriggerMax) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
