/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEventParameterChangeOfValueCivCriteria is the corresponding interface of BACnetEventParameterChangeOfValueCivCriteria
type BACnetEventParameterChangeOfValueCivCriteria interface {
	BACnetEventParameterChangeOfValueCivCriteriaContract
	BACnetEventParameterChangeOfValueCivCriteriaRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetEventParameterChangeOfValueCivCriteria is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEventParameterChangeOfValueCivCriteria()
	// CreateBuilder creates a BACnetEventParameterChangeOfValueCivCriteriaBuilder
	CreateBACnetEventParameterChangeOfValueCivCriteriaBuilder() BACnetEventParameterChangeOfValueCivCriteriaBuilder
}

// BACnetEventParameterChangeOfValueCivCriteriaContract provides a set of functions which can be overwritten by a sub struct
type BACnetEventParameterChangeOfValueCivCriteriaContract interface {
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// GetTagNumber() returns a parser argument
	GetTagNumber() uint8
	// IsBACnetEventParameterChangeOfValueCivCriteria is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEventParameterChangeOfValueCivCriteria()
	// CreateBuilder creates a BACnetEventParameterChangeOfValueCivCriteriaBuilder
	CreateBACnetEventParameterChangeOfValueCivCriteriaBuilder() BACnetEventParameterChangeOfValueCivCriteriaBuilder
}

// BACnetEventParameterChangeOfValueCivCriteriaRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetEventParameterChangeOfValueCivCriteriaRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedTagNumber returns PeekedTagNumber (discriminator field)
	GetPeekedTagNumber() uint8
}

// _BACnetEventParameterChangeOfValueCivCriteria is the data-structure of this message
type _BACnetEventParameterChangeOfValueCivCriteria struct {
	_SubType interface {
		BACnetEventParameterChangeOfValueCivCriteriaContract
		BACnetEventParameterChangeOfValueCivCriteriaRequirements
	}
	OpeningTag      BACnetOpeningTag
	PeekedTagHeader BACnetTagHeader
	ClosingTag      BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetEventParameterChangeOfValueCivCriteriaContract = (*_BACnetEventParameterChangeOfValueCivCriteria)(nil)

// NewBACnetEventParameterChangeOfValueCivCriteria factory function for _BACnetEventParameterChangeOfValueCivCriteria
func NewBACnetEventParameterChangeOfValueCivCriteria(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetEventParameterChangeOfValueCivCriteria {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetEventParameterChangeOfValueCivCriteria must not be nil")
	}
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetEventParameterChangeOfValueCivCriteria must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetEventParameterChangeOfValueCivCriteria must not be nil")
	}
	return &_BACnetEventParameterChangeOfValueCivCriteria{OpeningTag: openingTag, PeekedTagHeader: peekedTagHeader, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetEventParameterChangeOfValueCivCriteriaBuilder is a builder for BACnetEventParameterChangeOfValueCivCriteria
type BACnetEventParameterChangeOfValueCivCriteriaBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) BACnetEventParameterChangeOfValueCivCriteriaBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetEventParameterChangeOfValueCivCriteriaBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetEventParameterChangeOfValueCivCriteriaBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetEventParameterChangeOfValueCivCriteriaBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEventParameterChangeOfValueCivCriteriaBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetEventParameterChangeOfValueCivCriteriaBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetEventParameterChangeOfValueCivCriteriaBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetEventParameterChangeOfValueCivCriteriaBuilder
	// AsBACnetEventParameterChangeOfValueCivCriteriaBitmask converts this build to a subType of BACnetEventParameterChangeOfValueCivCriteria. It is always possible to return to current builder using Done()
	AsBACnetEventParameterChangeOfValueCivCriteriaBitmask() BACnetEventParameterChangeOfValueCivCriteriaBitmaskBuilder
	// AsBACnetEventParameterChangeOfValueCivCriteriaReferencedPropertyIncrement converts this build to a subType of BACnetEventParameterChangeOfValueCivCriteria. It is always possible to return to current builder using Done()
	AsBACnetEventParameterChangeOfValueCivCriteriaReferencedPropertyIncrement() BACnetEventParameterChangeOfValueCivCriteriaReferencedPropertyIncrementBuilder
	// Build builds the BACnetEventParameterChangeOfValueCivCriteria or returns an error if something is wrong
	PartialBuild() (BACnetEventParameterChangeOfValueCivCriteriaContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetEventParameterChangeOfValueCivCriteriaContract
	// Build builds the BACnetEventParameterChangeOfValueCivCriteria or returns an error if something is wrong
	Build() (BACnetEventParameterChangeOfValueCivCriteria, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetEventParameterChangeOfValueCivCriteria
}

// NewBACnetEventParameterChangeOfValueCivCriteriaBuilder() creates a BACnetEventParameterChangeOfValueCivCriteriaBuilder
func NewBACnetEventParameterChangeOfValueCivCriteriaBuilder() BACnetEventParameterChangeOfValueCivCriteriaBuilder {
	return &_BACnetEventParameterChangeOfValueCivCriteriaBuilder{_BACnetEventParameterChangeOfValueCivCriteria: new(_BACnetEventParameterChangeOfValueCivCriteria)}
}

type _BACnetEventParameterChangeOfValueCivCriteriaChildBuilder interface {
	utils.Copyable
	setParent(BACnetEventParameterChangeOfValueCivCriteriaContract)
	buildForBACnetEventParameterChangeOfValueCivCriteria() (BACnetEventParameterChangeOfValueCivCriteria, error)
}

type _BACnetEventParameterChangeOfValueCivCriteriaBuilder struct {
	*_BACnetEventParameterChangeOfValueCivCriteria

	childBuilder _BACnetEventParameterChangeOfValueCivCriteriaChildBuilder

	collectedErr []error
}

var _ (BACnetEventParameterChangeOfValueCivCriteriaBuilder) = (*_BACnetEventParameterChangeOfValueCivCriteriaBuilder)(nil)

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) BACnetEventParameterChangeOfValueCivCriteriaBuilder {
	return b.WithOpeningTag(openingTag).WithPeekedTagHeader(peekedTagHeader).WithClosingTag(closingTag)
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetEventParameterChangeOfValueCivCriteriaBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetEventParameterChangeOfValueCivCriteriaBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetEventParameterChangeOfValueCivCriteriaBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEventParameterChangeOfValueCivCriteriaBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetEventParameterChangeOfValueCivCriteriaBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetEventParameterChangeOfValueCivCriteriaBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) WithArgTagNumber(tagNumber uint8) BACnetEventParameterChangeOfValueCivCriteriaBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) PartialBuild() (BACnetEventParameterChangeOfValueCivCriteriaContract, error) {
	if b.OpeningTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'openingTag' not set"))
	}
	if b.PeekedTagHeader == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if b.ClosingTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'closingTag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetEventParameterChangeOfValueCivCriteria.deepCopy(), nil
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) PartialMustBuild() BACnetEventParameterChangeOfValueCivCriteriaContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) AsBACnetEventParameterChangeOfValueCivCriteriaBitmask() BACnetEventParameterChangeOfValueCivCriteriaBitmaskBuilder {
	if cb, ok := b.childBuilder.(BACnetEventParameterChangeOfValueCivCriteriaBitmaskBuilder); ok {
		return cb
	}
	cb := NewBACnetEventParameterChangeOfValueCivCriteriaBitmaskBuilder().(*_BACnetEventParameterChangeOfValueCivCriteriaBitmaskBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) AsBACnetEventParameterChangeOfValueCivCriteriaReferencedPropertyIncrement() BACnetEventParameterChangeOfValueCivCriteriaReferencedPropertyIncrementBuilder {
	if cb, ok := b.childBuilder.(BACnetEventParameterChangeOfValueCivCriteriaReferencedPropertyIncrementBuilder); ok {
		return cb
	}
	cb := NewBACnetEventParameterChangeOfValueCivCriteriaReferencedPropertyIncrementBuilder().(*_BACnetEventParameterChangeOfValueCivCriteriaReferencedPropertyIncrementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) Build() (BACnetEventParameterChangeOfValueCivCriteria, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetEventParameterChangeOfValueCivCriteria()
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) MustBuild() BACnetEventParameterChangeOfValueCivCriteria {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEventParameterChangeOfValueCivCriteriaBuilder) DeepCopy() any {
	_copy := b.CreateBACnetEventParameterChangeOfValueCivCriteriaBuilder().(*_BACnetEventParameterChangeOfValueCivCriteriaBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetEventParameterChangeOfValueCivCriteriaChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetEventParameterChangeOfValueCivCriteriaBuilder creates a BACnetEventParameterChangeOfValueCivCriteriaBuilder
func (b *_BACnetEventParameterChangeOfValueCivCriteria) CreateBACnetEventParameterChangeOfValueCivCriteriaBuilder() BACnetEventParameterChangeOfValueCivCriteriaBuilder {
	if b == nil {
		return NewBACnetEventParameterChangeOfValueCivCriteriaBuilder()
	}
	return &_BACnetEventParameterChangeOfValueCivCriteriaBuilder{_BACnetEventParameterChangeOfValueCivCriteria: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetEventParameterChangeOfValueCivCriteria) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetEventParameterChangeOfValueCivCriteria) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

func (m *_BACnetEventParameterChangeOfValueCivCriteria) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetEventParameterChangeOfValueCivCriteria) GetPeekedTagNumber() uint8 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetEventParameterChangeOfValueCivCriteria(structType any) BACnetEventParameterChangeOfValueCivCriteria {
	if casted, ok := structType.(BACnetEventParameterChangeOfValueCivCriteria); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetEventParameterChangeOfValueCivCriteria); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetEventParameterChangeOfValueCivCriteria) GetTypeName() string {
	return "BACnetEventParameterChangeOfValueCivCriteria"
}

func (m *_BACnetEventParameterChangeOfValueCivCriteria) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetEventParameterChangeOfValueCivCriteria) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetEventParameterChangeOfValueCivCriteria) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetEventParameterChangeOfValueCivCriteriaParse[T BACnetEventParameterChangeOfValueCivCriteria](ctx context.Context, theBytes []byte, tagNumber uint8) (T, error) {
	return BACnetEventParameterChangeOfValueCivCriteriaParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetEventParameterChangeOfValueCivCriteriaParseWithBufferProducer[T BACnetEventParameterChangeOfValueCivCriteria](tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetEventParameterChangeOfValueCivCriteriaParseWithBuffer[T](ctx, readBuffer, tagNumber)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetEventParameterChangeOfValueCivCriteriaParseWithBuffer[T BACnetEventParameterChangeOfValueCivCriteria](ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (T, error) {
	v, err := (&_BACnetEventParameterChangeOfValueCivCriteria{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetEventParameterChangeOfValueCivCriteria) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetEventParameterChangeOfValueCivCriteria BACnetEventParameterChangeOfValueCivCriteria, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetEventParameterChangeOfValueCivCriteria"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetEventParameterChangeOfValueCivCriteria")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetEventParameterChangeOfValueCivCriteria
	switch {
	case peekedTagNumber == uint8(0): // BACnetEventParameterChangeOfValueCivCriteriaBitmask
		if _child, err = new(_BACnetEventParameterChangeOfValueCivCriteriaBitmask).parse(ctx, readBuffer, m, tagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetEventParameterChangeOfValueCivCriteriaBitmask for type-switch of BACnetEventParameterChangeOfValueCivCriteria")
		}
	case peekedTagNumber == uint8(1): // BACnetEventParameterChangeOfValueCivCriteriaReferencedPropertyIncrement
		if _child, err = new(_BACnetEventParameterChangeOfValueCivCriteriaReferencedPropertyIncrement).parse(ctx, readBuffer, m, tagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetEventParameterChangeOfValueCivCriteriaReferencedPropertyIncrement for type-switch of BACnetEventParameterChangeOfValueCivCriteria")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v]", peekedTagNumber)
	}

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetEventParameterChangeOfValueCivCriteria"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetEventParameterChangeOfValueCivCriteria")
	}

	return _child, nil
}

func (pm *_BACnetEventParameterChangeOfValueCivCriteria) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetEventParameterChangeOfValueCivCriteria, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetEventParameterChangeOfValueCivCriteria"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetEventParameterChangeOfValueCivCriteria")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetEventParameterChangeOfValueCivCriteria"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetEventParameterChangeOfValueCivCriteria")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetEventParameterChangeOfValueCivCriteria) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetEventParameterChangeOfValueCivCriteria) IsBACnetEventParameterChangeOfValueCivCriteria() {
}

func (m *_BACnetEventParameterChangeOfValueCivCriteria) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetEventParameterChangeOfValueCivCriteria) deepCopy() *_BACnetEventParameterChangeOfValueCivCriteria {
	if m == nil {
		return nil
	}
	_BACnetEventParameterChangeOfValueCivCriteriaCopy := &_BACnetEventParameterChangeOfValueCivCriteria{
		nil, // will be set by child
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetEventParameterChangeOfValueCivCriteriaCopy
}
