/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataNotificationClassAll is the corresponding interface of BACnetConstructedDataNotificationClassAll
type BACnetConstructedDataNotificationClassAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataNotificationClassAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataNotificationClassAll()
	// CreateBuilder creates a BACnetConstructedDataNotificationClassAllBuilder
	CreateBACnetConstructedDataNotificationClassAllBuilder() BACnetConstructedDataNotificationClassAllBuilder
}

// _BACnetConstructedDataNotificationClassAll is the data-structure of this message
type _BACnetConstructedDataNotificationClassAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataNotificationClassAll = (*_BACnetConstructedDataNotificationClassAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataNotificationClassAll)(nil)

// NewBACnetConstructedDataNotificationClassAll factory function for _BACnetConstructedDataNotificationClassAll
func NewBACnetConstructedDataNotificationClassAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataNotificationClassAll {
	_result := &_BACnetConstructedDataNotificationClassAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataNotificationClassAllBuilder is a builder for BACnetConstructedDataNotificationClassAll
type BACnetConstructedDataNotificationClassAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataNotificationClassAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataNotificationClassAll or returns an error if something is wrong
	Build() (BACnetConstructedDataNotificationClassAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataNotificationClassAll
}

// NewBACnetConstructedDataNotificationClassAllBuilder() creates a BACnetConstructedDataNotificationClassAllBuilder
func NewBACnetConstructedDataNotificationClassAllBuilder() BACnetConstructedDataNotificationClassAllBuilder {
	return &_BACnetConstructedDataNotificationClassAllBuilder{_BACnetConstructedDataNotificationClassAll: new(_BACnetConstructedDataNotificationClassAll)}
}

type _BACnetConstructedDataNotificationClassAllBuilder struct {
	*_BACnetConstructedDataNotificationClassAll

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataNotificationClassAllBuilder) = (*_BACnetConstructedDataNotificationClassAllBuilder)(nil)

func (b *_BACnetConstructedDataNotificationClassAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataNotificationClassAll
}

func (b *_BACnetConstructedDataNotificationClassAllBuilder) WithMandatoryFields() BACnetConstructedDataNotificationClassAllBuilder {
	return b
}

func (b *_BACnetConstructedDataNotificationClassAllBuilder) Build() (BACnetConstructedDataNotificationClassAll, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataNotificationClassAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataNotificationClassAllBuilder) MustBuild() BACnetConstructedDataNotificationClassAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataNotificationClassAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataNotificationClassAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataNotificationClassAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataNotificationClassAllBuilder().(*_BACnetConstructedDataNotificationClassAllBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataNotificationClassAllBuilder creates a BACnetConstructedDataNotificationClassAllBuilder
func (b *_BACnetConstructedDataNotificationClassAll) CreateBACnetConstructedDataNotificationClassAllBuilder() BACnetConstructedDataNotificationClassAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataNotificationClassAllBuilder()
	}
	return &_BACnetConstructedDataNotificationClassAllBuilder{_BACnetConstructedDataNotificationClassAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataNotificationClassAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_NOTIFICATION_CLASS
}

func (m *_BACnetConstructedDataNotificationClassAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataNotificationClassAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataNotificationClassAll(structType any) BACnetConstructedDataNotificationClassAll {
	if casted, ok := structType.(BACnetConstructedDataNotificationClassAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataNotificationClassAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataNotificationClassAll) GetTypeName() string {
	return "BACnetConstructedDataNotificationClassAll"
}

func (m *_BACnetConstructedDataNotificationClassAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataNotificationClassAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataNotificationClassAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataNotificationClassAll BACnetConstructedDataNotificationClassAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataNotificationClassAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataNotificationClassAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataNotificationClassAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataNotificationClassAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataNotificationClassAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataNotificationClassAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataNotificationClassAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataNotificationClassAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataNotificationClassAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataNotificationClassAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataNotificationClassAll) IsBACnetConstructedDataNotificationClassAll() {}

func (m *_BACnetConstructedDataNotificationClassAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataNotificationClassAll) deepCopy() *_BACnetConstructedDataNotificationClassAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataNotificationClassAllCopy := &_BACnetConstructedDataNotificationClassAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataNotificationClassAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataNotificationClassAllCopy
}

func (m *_BACnetConstructedDataNotificationClassAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
