/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLandingDoorStatus is the corresponding interface of BACnetConstructedDataLandingDoorStatus
type BACnetConstructedDataLandingDoorStatus interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetNumberOfDataElements returns NumberOfDataElements (property field)
	GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger
	// GetLandingDoorStatus returns LandingDoorStatus (property field)
	GetLandingDoorStatus() []BACnetLandingDoorStatus
	// GetZero returns Zero (virtual field)
	GetZero() uint64
	// IsBACnetConstructedDataLandingDoorStatus is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLandingDoorStatus()
	// CreateBuilder creates a BACnetConstructedDataLandingDoorStatusBuilder
	CreateBACnetConstructedDataLandingDoorStatusBuilder() BACnetConstructedDataLandingDoorStatusBuilder
}

// _BACnetConstructedDataLandingDoorStatus is the data-structure of this message
type _BACnetConstructedDataLandingDoorStatus struct {
	BACnetConstructedDataContract
	NumberOfDataElements BACnetApplicationTagUnsignedInteger
	LandingDoorStatus    []BACnetLandingDoorStatus
}

var _ BACnetConstructedDataLandingDoorStatus = (*_BACnetConstructedDataLandingDoorStatus)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLandingDoorStatus)(nil)

// NewBACnetConstructedDataLandingDoorStatus factory function for _BACnetConstructedDataLandingDoorStatus
func NewBACnetConstructedDataLandingDoorStatus(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, numberOfDataElements BACnetApplicationTagUnsignedInteger, landingDoorStatus []BACnetLandingDoorStatus, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLandingDoorStatus {
	_result := &_BACnetConstructedDataLandingDoorStatus{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		NumberOfDataElements:          numberOfDataElements,
		LandingDoorStatus:             landingDoorStatus,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLandingDoorStatusBuilder is a builder for BACnetConstructedDataLandingDoorStatus
type BACnetConstructedDataLandingDoorStatusBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(landingDoorStatus []BACnetLandingDoorStatus) BACnetConstructedDataLandingDoorStatusBuilder
	// WithNumberOfDataElements adds NumberOfDataElements (property field)
	WithOptionalNumberOfDataElements(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLandingDoorStatusBuilder
	// WithOptionalNumberOfDataElementsBuilder adds NumberOfDataElements (property field) which is build by the builder
	WithOptionalNumberOfDataElementsBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataLandingDoorStatusBuilder
	// WithLandingDoorStatus adds LandingDoorStatus (property field)
	WithLandingDoorStatus(...BACnetLandingDoorStatus) BACnetConstructedDataLandingDoorStatusBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLandingDoorStatus or returns an error if something is wrong
	Build() (BACnetConstructedDataLandingDoorStatus, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLandingDoorStatus
}

// NewBACnetConstructedDataLandingDoorStatusBuilder() creates a BACnetConstructedDataLandingDoorStatusBuilder
func NewBACnetConstructedDataLandingDoorStatusBuilder() BACnetConstructedDataLandingDoorStatusBuilder {
	return &_BACnetConstructedDataLandingDoorStatusBuilder{_BACnetConstructedDataLandingDoorStatus: new(_BACnetConstructedDataLandingDoorStatus)}
}

type _BACnetConstructedDataLandingDoorStatusBuilder struct {
	*_BACnetConstructedDataLandingDoorStatus

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataLandingDoorStatusBuilder) = (*_BACnetConstructedDataLandingDoorStatusBuilder)(nil)

func (b *_BACnetConstructedDataLandingDoorStatusBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLandingDoorStatus
}

func (b *_BACnetConstructedDataLandingDoorStatusBuilder) WithMandatoryFields(landingDoorStatus []BACnetLandingDoorStatus) BACnetConstructedDataLandingDoorStatusBuilder {
	return b.WithLandingDoorStatus(landingDoorStatus...)
}

func (b *_BACnetConstructedDataLandingDoorStatusBuilder) WithOptionalNumberOfDataElements(numberOfDataElements BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLandingDoorStatusBuilder {
	b.NumberOfDataElements = numberOfDataElements
	return b
}

func (b *_BACnetConstructedDataLandingDoorStatusBuilder) WithOptionalNumberOfDataElementsBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataLandingDoorStatusBuilder {
	builder := builderSupplier(b.NumberOfDataElements.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.NumberOfDataElements, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLandingDoorStatusBuilder) WithLandingDoorStatus(landingDoorStatus ...BACnetLandingDoorStatus) BACnetConstructedDataLandingDoorStatusBuilder {
	b.LandingDoorStatus = landingDoorStatus
	return b
}

func (b *_BACnetConstructedDataLandingDoorStatusBuilder) Build() (BACnetConstructedDataLandingDoorStatus, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataLandingDoorStatus.deepCopy(), nil
}

func (b *_BACnetConstructedDataLandingDoorStatusBuilder) MustBuild() BACnetConstructedDataLandingDoorStatus {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLandingDoorStatusBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLandingDoorStatusBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLandingDoorStatusBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLandingDoorStatusBuilder().(*_BACnetConstructedDataLandingDoorStatusBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataLandingDoorStatusBuilder creates a BACnetConstructedDataLandingDoorStatusBuilder
func (b *_BACnetConstructedDataLandingDoorStatus) CreateBACnetConstructedDataLandingDoorStatusBuilder() BACnetConstructedDataLandingDoorStatusBuilder {
	if b == nil {
		return NewBACnetConstructedDataLandingDoorStatusBuilder()
	}
	return &_BACnetConstructedDataLandingDoorStatusBuilder{_BACnetConstructedDataLandingDoorStatus: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLandingDoorStatus) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLandingDoorStatus) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LANDING_DOOR_STATUS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLandingDoorStatus) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLandingDoorStatus) GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger {
	return m.NumberOfDataElements
}

func (m *_BACnetConstructedDataLandingDoorStatus) GetLandingDoorStatus() []BACnetLandingDoorStatus {
	return m.LandingDoorStatus
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLandingDoorStatus) GetZero() uint64 {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.GetNumberOfDataElements()
	_ = numberOfDataElements
	return uint64(uint64(0))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLandingDoorStatus(structType any) BACnetConstructedDataLandingDoorStatus {
	if casted, ok := structType.(BACnetConstructedDataLandingDoorStatus); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLandingDoorStatus); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLandingDoorStatus) GetTypeName() string {
	return "BACnetConstructedDataLandingDoorStatus"
}

func (m *_BACnetConstructedDataLandingDoorStatus) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// A virtual field doesn't have any in- or output.

	// Optional Field (numberOfDataElements)
	if m.NumberOfDataElements != nil {
		lengthInBits += m.NumberOfDataElements.GetLengthInBits(ctx)
	}

	// Array field
	if len(m.LandingDoorStatus) > 0 {
		for _, element := range m.LandingDoorStatus {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataLandingDoorStatus) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLandingDoorStatus) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLandingDoorStatus BACnetConstructedDataLandingDoorStatus, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLandingDoorStatus"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLandingDoorStatus")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zero, err := ReadVirtualField[uint64](ctx, "zero", (*uint64)(nil), uint64(0))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zero' field"))
	}
	_ = zero

	var numberOfDataElements BACnetApplicationTagUnsignedInteger
	_numberOfDataElements, err := ReadOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfDataElements", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer), bool(bool((arrayIndexArgument) != (nil))) && bool(bool((arrayIndexArgument.GetActualValue()) == (zero))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberOfDataElements' field"))
	}
	if _numberOfDataElements != nil {
		numberOfDataElements = *_numberOfDataElements
		m.NumberOfDataElements = numberOfDataElements
	}

	landingDoorStatus, err := ReadTerminatedArrayField[BACnetLandingDoorStatus](ctx, "landingDoorStatus", ReadComplex[BACnetLandingDoorStatus](BACnetLandingDoorStatusParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'landingDoorStatus' field"))
	}
	m.LandingDoorStatus = landingDoorStatus

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLandingDoorStatus"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLandingDoorStatus")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLandingDoorStatus) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLandingDoorStatus) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLandingDoorStatus"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLandingDoorStatus")
		}
		// Virtual field
		zero := m.GetZero()
		_ = zero
		if _zeroErr := writeBuffer.WriteVirtual(ctx, "zero", m.GetZero()); _zeroErr != nil {
			return errors.Wrap(_zeroErr, "Error serializing 'zero' field")
		}

		if err := WriteOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfDataElements", GetRef(m.GetNumberOfDataElements()), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'numberOfDataElements' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "landingDoorStatus", m.GetLandingDoorStatus(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'landingDoorStatus' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLandingDoorStatus"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLandingDoorStatus")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLandingDoorStatus) IsBACnetConstructedDataLandingDoorStatus() {}

func (m *_BACnetConstructedDataLandingDoorStatus) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLandingDoorStatus) deepCopy() *_BACnetConstructedDataLandingDoorStatus {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLandingDoorStatusCopy := &_BACnetConstructedDataLandingDoorStatus{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.NumberOfDataElements),
		utils.DeepCopySlice[BACnetLandingDoorStatus, BACnetLandingDoorStatus](m.LandingDoorStatus),
	}
	_BACnetConstructedDataLandingDoorStatusCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLandingDoorStatusCopy
}

func (m *_BACnetConstructedDataLandingDoorStatus) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
