/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;

public class PageEntry {
    private final COSDictionary dict;
    private final int pageNum;
    private final String pageLabel;

    public PageEntry(COSDictionary page, int pageNum, String pageLabel) {
        this.dict = page;
        this.pageNum = pageNum;
        this.pageLabel = pageLabel;
    }

    public COSDictionary getDict() {
        return this.dict;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public String toString() {
        return "Page: " + this.pageNum + (this.pageLabel == null ? "" : " - " + this.pageLabel);
    }

    public String getPath() {
        StringBuilder sb = new StringBuilder();
        sb.append("Root/Pages");
        COSDictionary node = this.dict;
        while (node.containsKey(COSName.PARENT)) {
            COSBase base = node.getDictionaryObject(COSName.PARENT);
            if (!(base instanceof COSDictionary)) {
                return "";
            }
            COSDictionary parent = (COSDictionary)base;
            if (!((base = parent.getDictionaryObject(COSName.KIDS)) instanceof COSArray)) {
                return "";
            }
            COSArray kids = (COSArray)base;
            int idx = kids.indexOfObject((COSBase)node);
            if (idx == -1) break;
            sb.append("/Kids/[").append(idx).append("]");
            node = parent;
        }
        return sb.toString();
    }
}

