/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.client;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;

public abstract class DefaultInvocationHandler
implements InvocationHandler {
    private static final Set<String> DEFAULT_METHODS = ImmutableSet.of((Object)"toString", (Object)"notify", (Object)"notifyAll", (Object)"wait", (Object)"getClass", (Object)"clone", (Object[])new String[]{"equals", "hashCode"});

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (DEFAULT_METHODS.contains(methodName)) {
            return this.findMethod(this, methodName, args).invoke((Object)this, args);
        }
        return this.internalInvoke(proxy, method, args);
    }

    protected Method findMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException {
        block0: for (Method method : object.getClass().getMethods()) {
            if (!method.getName().equals(methodName) || !this.sameParams(method, args)) continue;
            int numParam = 0;
            for (Class<?> type : method.getParameterTypes()) {
                if (numParam < args.length && !type.isAssignableFrom(args[numParam].getClass())) continue block0;
                ++numParam;
            }
            return method;
        }
        throw new NoSuchMethodException(object.getClass().getName() + ":" + methodName + " Params: " + Arrays.toString(args));
    }

    private boolean sameParams(Method method, Object[] args) {
        if (args == null) {
            return method.getParameterAnnotations().length == 0;
        }
        return method.getParameterAnnotations().length == args.length;
    }

    protected abstract Object internalInvoke(Object var1, Method var2, Object[] var3) throws Throwable;
}

