/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.internal.util.ResultSet;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.PagingPredicateImpl;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class SortingUtil {
    private SortingUtil() {
    }

    public static int compare(Comparator<Map.Entry> comparator, IterationType iterationType, Map.Entry entry1, Map.Entry entry2) {
        Object comparable1;
        if (comparator != null) {
            int result = comparator.compare(entry1, entry2);
            if (result != 0) {
                return result;
            }
            return SortingUtil.compareIntegers(entry1.getKey().hashCode(), entry2.getKey().hashCode());
        }
        Object comparable2 = switch (iterationType) {
            case IterationType.KEY -> {
                comparable1 = entry1.getKey();
                yield entry2.getKey();
            }
            case IterationType.VALUE -> {
                comparable1 = entry1.getValue();
                yield entry2.getValue();
            }
            default -> {
                if (entry1 instanceof Comparable && entry2 instanceof Comparable) {
                    comparable1 = entry1;
                    yield entry2;
                }
                comparable1 = entry1.getKey();
                yield entry2.getKey();
            }
        };
        SortingUtil.checkIfComparable(comparable1);
        SortingUtil.checkIfComparable(comparable2);
        int result = ((Comparable)comparable1).compareTo(comparable2);
        if (result != 0) {
            return result;
        }
        return SortingUtil.compareIntegers(entry1.getKey().hashCode(), entry2.getKey().hashCode());
    }

    private static void checkIfComparable(Object comparable) {
        if (comparable instanceof Comparable) {
            return;
        }
        throw new IllegalArgumentException("Not comparable " + comparable);
    }

    private static int compareIntegers(int i1, int i2) {
        if (i1 > i2) {
            return 1;
        }
        if (i2 > i1) {
            return -1;
        }
        return 0;
    }

    public static Comparator<Map.Entry> newComparator(Comparator<Map.Entry> comparator, IterationType iterationType) {
        return (entry1, entry2) -> SortingUtil.compare(comparator, iterationType, entry1, entry2);
    }

    private static Comparator<QueryableEntry> newComparator(PagingPredicateImpl pagingPredicate) {
        return NamespaceUtil.callWithNamespace(pagingPredicate.getUserCodeNamespace(), () -> (entry1, entry2) -> SortingUtil.compare(pagingPredicate.getComparator(), pagingPredicate.getIterationType(), entry1, entry2));
    }

    public static List<QueryableEntry> getSortedSubList(List<QueryableEntry> list, PagingPredicate pagingPredicate, Map.Entry<Integer, Map.Entry> nearestAnchorEntry) {
        if (pagingPredicate == null || list.isEmpty()) {
            return list;
        }
        PagingPredicateImpl pagingPredicateImpl = (PagingPredicateImpl)pagingPredicate;
        Comparator<QueryableEntry> comparator = SortingUtil.newComparator(pagingPredicateImpl);
        Collections.sort(list, comparator);
        int nearestPage = nearestAnchorEntry.getKey();
        int pageSize = pagingPredicate.getPageSize();
        int page = pagingPredicate.getPage();
        long totalSize = (long)pageSize * ((long)page - (long)nearestPage);
        if ((long)list.size() > totalSize) {
            list = list.subList(0, (int)totalSize);
        }
        return list;
    }

    public static ResultSet getSortedQueryResultSet(List<Map.Entry> list, PagingPredicateImpl pagingPredicate, IterationType iterationType) {
        List<? extends Map.Entry> subList = SortingUtil.getSortedSubListAndUpdateAnchor(list, pagingPredicate, iterationType);
        return new ResultSet(subList, iterationType);
    }

    public static boolean compareAnchor(PagingPredicate pagingPredicate, QueryableEntry queryEntry, Map.Entry<Integer, Map.Entry> nearestAnchorEntry) {
        if (pagingPredicate == null) {
            return true;
        }
        Map.Entry anchor = nearestAnchorEntry.getValue();
        if (anchor == null) {
            return true;
        }
        PagingPredicateImpl pagingPredicateImpl = (PagingPredicateImpl)pagingPredicate;
        Comparator comparator = pagingPredicate.getComparator();
        IterationType iterationType = pagingPredicateImpl.getIterationType();
        return NamespaceUtil.callWithNamespace(pagingPredicateImpl.getUserCodeNamespace(), () -> SortingUtil.compare(comparator, iterationType, anchor, queryEntry) < 0);
    }

    public static List getSortedSubListData(List<QueryableEntry> list, PagingPredicateImpl pagingPredicate) {
        IterationType iterationType = pagingPredicate.getIterationType();
        Map.Entry<Integer, Integer> pageIndex = SortingUtil.getPageIndexesAndUpdateAnchor(list, pagingPredicate, iterationType);
        int begin = pageIndex.getKey();
        int end = pageIndex.getValue();
        if (begin == -1) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(end - begin);
        block4: for (int i = begin; i < end; ++i) {
            CachedQueryEntry entry = (CachedQueryEntry)list.get(i);
            switch (iterationType) {
                case KEY: {
                    result.add(entry.getKeyData());
                    continue block4;
                }
                case VALUE: {
                    result.add(entry.getValueData());
                    continue block4;
                }
                default: {
                    result.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(entry.getKeyData(), entry.getValueData()));
                }
            }
        }
        return result;
    }

    private static List<? extends Map.Entry> getSortedSubListAndUpdateAnchor(List<? extends Map.Entry> list, PagingPredicateImpl pagingPredicate, IterationType iterationType) {
        Map.Entry<Integer, Integer> pageIndex = SortingUtil.getPageIndexesAndUpdateAnchor(list, pagingPredicate, iterationType);
        int begin = pageIndex.getKey();
        int end = pageIndex.getValue();
        if (begin == -1) {
            return Collections.emptyList();
        }
        return list.subList(begin, end);
    }

    private static Map.Entry<Integer, Integer> getPageIndexesAndUpdateAnchor(List<? extends Map.Entry> list, PagingPredicateImpl pagingPredicateImpl, IterationType iterationType) {
        if (list.isEmpty()) {
            return new AbstractMap.SimpleImmutableEntry<Integer, Integer>(-1, -1);
        }
        Comparator<Map.Entry> comparator = SortingUtil.newComparator(pagingPredicateImpl.getComparator(), iterationType);
        Collections.sort(list, comparator);
        Map.Entry<Integer, Map.Entry> nearestAnchorEntry = pagingPredicateImpl.getNearestAnchorEntry();
        int nearestPage = nearestAnchorEntry.getKey();
        int page = pagingPredicateImpl.getPage();
        int pageSize = pagingPredicateImpl.getPageSize();
        long begin = (long)pageSize * ((long)page - (long)nearestPage - 1L);
        int size = list.size();
        if (begin > (long)size) {
            return new AbstractMap.SimpleImmutableEntry<Integer, Integer>(-1, -1);
        }
        long end = begin + (long)pageSize;
        if (end > (long)size) {
            end = size;
        }
        SortingUtil.setAnchor(list, pagingPredicateImpl, nearestPage);
        return new AbstractMap.SimpleImmutableEntry<Integer, Integer>((int)begin, (int)end);
    }

    private static void setAnchor(List<? extends Map.Entry> list, PagingPredicateImpl pagingPredicate, int nearestPage) {
        if (list.isEmpty()) {
            return;
        }
        int size = list.size();
        int pageSize = pagingPredicate.getPageSize();
        int page = pagingPredicate.getPage();
        for (int i = pageSize; i <= size && nearestPage < page; i += pageSize) {
            Map.Entry anchor = list.get(i - 1);
            pagingPredicate.setAnchor(++nearestPage, anchor);
        }
    }
}

