/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class NetworkInterfaceInfo {
    private final boolean up;
    private final boolean virtual;
    private final boolean loopback;
    private final String name;
    private final List<InetAddress> inetAddresses;

    NetworkInterfaceInfo(String name, boolean up, boolean virtual, boolean loopback, List<InetAddress> inetAddresses) {
        this.up = up;
        this.virtual = virtual;
        this.loopback = loopback;
        this.name = name;
        this.inetAddresses = inetAddresses;
    }

    public NetworkInterfaceInfo(NetworkInterface networkInterface) throws SocketException {
        this(networkInterface.getName(), networkInterface.isUp(), networkInterface.isVirtual(), networkInterface.isLoopback(), Collections.list(networkInterface.getInetAddresses()));
    }

    public boolean isUp() {
        return this.up;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public String getName() {
        return this.name;
    }

    public List<InetAddress> getInetAddresses() {
        return this.inetAddresses;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static final class Builder {
        private final String name;
        private boolean up = true;
        private boolean loopback;
        private boolean virtual;
        private String[] addresses = new String[0];
        private InetAddress[] inetAddresses;

        private Builder(String name) {
            this.name = name;
        }

        public Builder withUp(boolean up) {
            this.up = up;
            return this;
        }

        public Builder withLoopback(boolean loopback) {
            this.loopback = loopback;
            return this;
        }

        public Builder withVirtual(boolean virtual) {
            this.virtual = virtual;
            return this;
        }

        public Builder withAddresses(String ... addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder withInetAddresses(InetAddress ... addresses) {
            this.inetAddresses = addresses;
            return this;
        }

        private static List<InetAddress> createInetAddresses(String ... addresses) {
            ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>();
            for (String address : addresses) {
                try {
                    inetAddresses.add(InetAddress.getByName(address));
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
            return inetAddresses;
        }

        public NetworkInterfaceInfo build() {
            List<InetAddress> effectiveInetAddresses = this.inetAddresses == null ? Builder.createInetAddresses(this.addresses) : Arrays.asList(this.inetAddresses);
            return new NetworkInterfaceInfo(this.name, this.up, this.virtual, this.loopback, effectiveInetAddresses);
        }
    }
}

