/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl.executejar;

import com.hazelcast.instance.impl.BootstrappedJetProxy;
import com.hazelcast.instance.impl.executejar.ExecuteJobParameters;
import com.hazelcast.instance.impl.executejar.jetservicedecorator.memberside.BootstrapJobDecorator;
import com.hazelcast.jet.JetService;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.pipeline.Pipeline;
import javax.annotation.Nonnull;

public class MemberJetProxy<M>
extends BootstrappedJetProxy<M> {
    private final ThreadLocal<ExecuteJobParameters> executeJobParametersThreadLocal = ThreadLocal.withInitial(ExecuteJobParameters::new);

    public MemberJetProxy(@Nonnull JetService jetService) {
        super(jetService);
    }

    @Override
    public boolean hasExecuteJobParameters() {
        return this.getExecuteJobParameters() != null;
    }

    @Override
    public ExecuteJobParameters getExecuteJobParameters() {
        return this.executeJobParametersThreadLocal.get();
    }

    @Override
    public void setExecuteJobParameters(ExecuteJobParameters executeJobParameters) {
        this.executeJobParametersThreadLocal.set(executeJobParameters);
    }

    @Override
    public void removeExecuteJobParameters() {
        this.executeJobParametersThreadLocal.remove();
    }

    @Override
    @Nonnull
    public Job newJob(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
        Job job = super.newJob(pipeline, config);
        return new BootstrapJobDecorator(job);
    }

    @Override
    @Nonnull
    public Job newJob(@Nonnull DAG dag, @Nonnull JobConfig config) {
        Job job = super.newJob(dag, config);
        return new BootstrapJobDecorator(job);
    }

    @Override
    @Nonnull
    public Job newJobIfAbsent(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
        Job job = super.newJobIfAbsent(pipeline, config);
        return new BootstrapJobDecorator(job);
    }

    @Override
    @Nonnull
    public Job newJobIfAbsent(@Nonnull DAG dag, @Nonnull JobConfig config) {
        Job job = super.newJobIfAbsent(dag, config);
        return new BootstrapJobDecorator(job);
    }
}

