/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.exceptions.DOMValidationException;
import com.github.caldav4j.model.request.ParamFilter;
import com.github.caldav4j.model.request.PropProperty;
import com.github.caldav4j.model.request.TextMatch;
import com.github.caldav4j.model.request.TimeRange;
import com.github.caldav4j.xml.OutputsDOMBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.Date;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;

public class PropFilter
extends OutputsDOMBase {
    public static final String ELEMENT_NAME = "prop-filter";
    public static final String ELEM_IS_DEFINED = "is-defined";
    public static final String ELEM_IS_NOT_DEFINED = "is-not-defined";
    public static final String ATTR_NAME = "name";
    private String name = null;
    private Boolean isDefined = null;
    private TimeRange timeRange = null;
    private TextMatch textMatch = null;
    private List<ParamFilter> paramFilters = new ArrayList<ParamFilter>();

    public PropFilter() {
    }

    public PropFilter(String name, Boolean isDefined, Date timeRangeStart, Date timeRangeEnd, Boolean textmatchCaseless, boolean negateCondition, String textMatchCollation, String textMatchString, List<ParamFilter> paramFilters) {
        this.name = name;
        if (isDefined != null) {
            this.isDefined = isDefined;
        } else if (timeRangeStart != null || timeRangeEnd != null) {
            this.timeRange = new TimeRange(timeRangeStart, timeRangeEnd);
        } else if (textMatchString != null) {
            this.textMatch = new TextMatch(textmatchCaseless, negateCondition, textMatchCollation, textMatchString);
        }
        if (paramFilters != null) {
            this.paramFilters = paramFilters;
        }
    }

    public PropFilter(String name, boolean isDefined, Date timeRangeStart, Date timeRangeEnd, Boolean textmatchCaseless, String textMatchString, List<ParamFilter> paramFilters) {
        this.name = name;
        this.isDefined = isDefined;
        if (timeRangeStart != null && timeRangeEnd != null) {
            this.timeRange = new TimeRange(timeRangeStart, timeRangeEnd);
        } else if (textMatchString != null) {
            this.textMatch = new TextMatch(textmatchCaseless, false, null, textMatchString);
        }
        if (paramFilters != null) {
            this.paramFilters = paramFilters;
        }
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected Namespace getNamespace() {
        return CalDAVConstants.NAMESPACE_CALDAV;
    }

    protected Collection<XmlSerializable> getChildren() {
        ArrayList<XmlSerializable> children = new ArrayList<XmlSerializable>();
        if (this.isDefined != null) {
            children.add((XmlSerializable)new PropProperty(this.isDefined != false ? ELEM_IS_DEFINED : ELEM_IS_NOT_DEFINED, CalDAVConstants.NAMESPACE_CALDAV));
        } else if (this.timeRange != null) {
            children.add(this.timeRange);
        } else if (this.textMatch != null) {
            children.add(this.textMatch);
        }
        if (this.paramFilters != null && this.paramFilters.size() > 0) {
            children.addAll(this.paramFilters);
        }
        return children;
    }

    @Override
    protected String getTextContent() {
        return null;
    }

    @Override
    protected Map<String, String> getAttributes() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(ATTR_NAME, this.name);
        return m;
    }

    public Boolean isDefined() {
        return this.isDefined;
    }

    public void setIsDefined(Boolean isDefined) {
        this.isDefined = isDefined;
    }

    public List<ParamFilter> getParamFilters() {
        return this.paramFilters;
    }

    public void setParamFilters(List<ParamFilter> paramFilters) {
        this.paramFilters = paramFilters;
    }

    public void addParamFilter(ParamFilter paramFilter) {
        this.paramFilters.add(paramFilter);
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(Date start, Date end) {
        this.timeRange = new TimeRange(start, end);
    }

    public void setTimeRange(TimeRange timeRange) {
        this.timeRange = timeRange;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TextMatch getTextMatch() {
        return this.textMatch;
    }

    public void setTextMatch(TextMatch textMatch) {
        this.textMatch = textMatch;
    }

    @Override
    public void validate() throws DOMValidationException {
        if (this.name == null) {
            this.throwValidationException("Name is a required property");
        }
        if (this.isDefined != null && (this.timeRange != null || this.textMatch != null)) {
            this.throwValidationException("isDefined, timeRange and textMatch are mutually exclusive");
        }
        if (this.timeRange != null) {
            if (this.textMatch != null) {
                this.throwValidationException("isDefined, timeRange and textMatch are mutually exclusive");
            }
            this.timeRange.validate();
        } else if (this.textMatch != null) {
            this.textMatch.validate();
        }
        if (this.paramFilters != null) {
            this.validate(this.paramFilters);
        }
    }
}

