/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.app;

import com.github.openjson.JSONObject;
import com.hazelcast.map.IMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.WebSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class QuickPollManager {
    private static final Logger log = LoggerFactory.getLogger(QuickPollManager.class);
    private static final String QPOLLS_KEY = "QPOLLS_KEY";

    private static IMap<Long, Map<Long, Boolean>> map() {
        return Application.getHazelcast().getMap(QPOLLS_KEY);
    }

    public boolean isStarted(Long roomId) {
        return QuickPollManager.map().containsKey((Object)roomId);
    }

    public void start(Client c) {
        Long roomId = c.getRoomId();
        if (!c.hasRight(Room.Right.PRESENTER) || this.isStarted(roomId)) {
            return;
        }
        log.debug("Starting quick poll, room: {}", (Object)roomId);
        IMap<Long, Map<Long, Boolean>> polls = QuickPollManager.map();
        polls.lock((Object)roomId);
        polls.putIfAbsent((Object)roomId, new ConcurrentHashMap());
        polls.unlock((Object)roomId);
        WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(roomId, c, RoomMessage.Type.QUICK_POLL_UPDATED, c.getUid()));
    }

    public void vote(Client c, boolean vote) {
        Map votes;
        Long roomId = c.getRoomId();
        IMap<Long, Map<Long, Boolean>> polls = QuickPollManager.map();
        polls.lock((Object)roomId);
        if (polls.containsKey((Object)roomId) && !(votes = (Map)QuickPollManager.map().get((Object)roomId)).containsKey(c.getUserId())) {
            votes.put(c.getUserId(), vote);
            polls.put((Object)roomId, (Object)votes);
            WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(roomId, c, RoomMessage.Type.QUICK_POLL_UPDATED, c.getUid()));
        }
        polls.unlock((Object)roomId);
    }

    public void close(Client c) {
        Long roomId = c.getRoomId();
        if (!c.hasRight(Room.Right.PRESENTER) || !this.isStarted(roomId)) {
            return;
        }
        QuickPollManager.map().remove((Object)roomId);
        WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(roomId, c, RoomMessage.Type.QUICK_POLL_UPDATED, c.getUid()));
    }

    public JSONObject toJson(Long roomId) {
        boolean started = this.isStarted(roomId);
        JSONObject o = new JSONObject().put("started", started);
        if (started) {
            Map votes = (Map)QuickPollManager.map().get((Object)roomId);
            o.put("voted", votes.containsKey(WebSession.getUserId()));
            o.put("pros", votes.entrySet().stream().filter(Map.Entry::getValue).count()).put("cons", votes.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).count());
        }
        return o;
    }
}

