/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus.TempusDominusConfig;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.util.Json;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.wicket.util.lang.Args;

public class TempusDominusRestrictionsConfig
extends AbstractConfig {
    private static final long serialVersionUID = 1L;
    private static final IKey<Json.RawValue> MinDate = TempusDominusRestrictionsConfig.newKey((String)"minDate", null);
    private static final IKey<Json.RawValue> MaxDate = TempusDominusRestrictionsConfig.newKey((String)"maxDate", null);
    private static final IKey<List<Json.RawValue>> DisabledDates = TempusDominusRestrictionsConfig.newKey((String)"disabledDates", null);
    private static final IKey<List<Json.RawValue>> EnabledDates = TempusDominusRestrictionsConfig.newKey((String)"enabledDates", null);
    private static final IKey<List<Integer>> DaysOfWeekDisabled = TempusDominusRestrictionsConfig.newKey((String)"daysOfWeekDisabled", null);
    private static final IKey<List<Map<String, Json.RawValue>>> DisabledTimeIntervals = TempusDominusRestrictionsConfig.newKey((String)"disabledTimeIntervals", null);
    private static final IKey<List<Integer>> EnabledHours = TempusDominusRestrictionsConfig.newKey((String)"enabledHours", null);
    private static final IKey<List<Integer>> DisabledHours = TempusDominusRestrictionsConfig.newKey((String)"disabledHours", null);

    public TempusDominusRestrictionsConfig() {
        this.put(DisabledDates, new ArrayList());
        this.put(EnabledDates, new ArrayList());
        this.put(DaysOfWeekDisabled, new ArrayList());
        this.put(DisabledTimeIntervals, new ArrayList());
        this.put(EnabledHours, new ArrayList());
        this.put(DisabledHours, new ArrayList());
    }

    public <T extends Temporal> TempusDominusRestrictionsConfig withMinDate(T date) {
        this.put(MinDate, TempusDominusConfig.createJsDate(date));
        return this;
    }

    public TempusDominusRestrictionsConfig withMinDate(Date date) {
        this.put(MinDate, TempusDominusConfig.createJsDate(date));
        return this;
    }

    public <T extends Temporal> TempusDominusRestrictionsConfig withMaxDate(T date) {
        this.put(MaxDate, TempusDominusConfig.createJsDate(date));
        return this;
    }

    public TempusDominusRestrictionsConfig withMaxDate(Date date) {
        this.put(MaxDate, TempusDominusConfig.createJsDate(date));
        return this;
    }

    public <T extends Temporal> TempusDominusRestrictionsConfig withDisabledDate(T date) {
        Args.isTrue((boolean)((List)this.get(EnabledDates)).isEmpty(), (String)"Use one or the other, don't provide both enabledDates and disabledDates.", (Object[])new Object[0]);
        ((List)this.get(DisabledDates)).add(TempusDominusConfig.createJsDate(date));
        return this;
    }

    public TempusDominusRestrictionsConfig withDisabledDate(Date date) {
        Args.isTrue((boolean)((List)this.get(EnabledDates)).isEmpty(), (String)"Use one or the other, don't provide both enabledDates and disabledDates.", (Object[])new Object[0]);
        ((List)this.get(DisabledDates)).add(TempusDominusConfig.createJsDate(date));
        return this;
    }

    public <T extends Temporal> TempusDominusRestrictionsConfig withEnabledDate(T date) {
        Args.isTrue((boolean)((List)this.get(DisabledDates)).isEmpty(), (String)"Use one or the other, don't provide both enabledDates and disabledDates.", (Object[])new Object[0]);
        ((List)this.get(EnabledDates)).add(TempusDominusConfig.createJsDate(date));
        return this;
    }

    public TempusDominusRestrictionsConfig withEnabledDate(Date date) {
        Args.isTrue((boolean)((List)this.get(DisabledDates)).isEmpty(), (String)"Use one or the other, don't provide both enabledDates and disabledDates.", (Object[])new Object[0]);
        ((List)this.get(EnabledDates)).add(TempusDominusConfig.createJsDate(date));
        return this;
    }

    public TempusDominusRestrictionsConfig withDayOfWeekDisabled(int day) {
        Args.withinRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(day), (String)"dayOfWeek");
        ((List)this.get(DaysOfWeekDisabled)).add(day);
        return this;
    }

    public <T extends Temporal> TempusDominusRestrictionsConfig withDisabledTimeInterval(T from, T to) {
        ((List)this.get(DisabledTimeIntervals)).add(Map.of("from", TempusDominusConfig.createJsDate(from), "to", TempusDominusConfig.createJsDate(to)));
        return this;
    }

    public TempusDominusRestrictionsConfig withDisabledTimeInterval(Date from, Date to) {
        ((List)this.get(DisabledTimeIntervals)).add(Map.of("from", TempusDominusConfig.createJsDate(from), "to", TempusDominusConfig.createJsDate(to)));
        return this;
    }

    public TempusDominusRestrictionsConfig withEnabledHour(int hour) {
        Args.isTrue((boolean)((List)this.get(DisabledHours)).isEmpty(), (String)"Use one or the other, don't provide both enabledHours and disabledHours.", (Object[])new Object[0]);
        Args.withinRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(23), (Comparable)Integer.valueOf(hour), (String)"hour");
        ((List)this.get(EnabledHours)).add(hour);
        return this;
    }

    public TempusDominusRestrictionsConfig withDisabledHour(int hour) {
        Args.isTrue((boolean)((List)this.get(EnabledHours)).isEmpty(), (String)"Use one or the other, don't provide both enabledHours and disabledHours.", (Object[])new Object[0]);
        Args.withinRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(23), (Comparable)Integer.valueOf(hour), (String)"hour");
        ((List)this.get(DisabledHours)).add(hour);
        return this;
    }
}

