/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.    
 */
package org.apache.openjpa.persistence.models.company.fetchlazy;

import javax.persistence.*;
import org.apache.openjpa.persistence.models.company.*;

@Entity(name="LAZ_PartTimeEmployee")
public class PartTimeEmployee extends Employee
    implements IPartTimeEmployee {
    @Basic(fetch=FetchType.LAZY)
    private float wage;

    @Basic(fetch=FetchType.LAZY)
    private int weeklyHours;

    public void setWage(float wage) {
        this.wage = wage;
    }

    public float getWage() {
        return this.wage;
    }


    public void setWeeklyHours(int weeklyHours) {
        this.weeklyHours = weeklyHours;
    }

    public int getWeeklyHours() {
        return this.weeklyHours;
    }
}
