/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.apache.olingo.client.api.EdmEnabledODataClient;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.core.ODataClientFactory;
import org.apache.olingo.client.core.edm.ClientCsdlEdmProvider;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.EdmProviderImpl;
import org.apache.olingo.ext.proxy.api.AbstractTerm;
import org.apache.olingo.ext.proxy.api.PersistenceManager;
import org.apache.olingo.ext.proxy.commons.EntityContainerInvocationHandler;
import org.apache.olingo.ext.proxy.commons.NonTransactionalPersistenceManagerImpl;
import org.apache.olingo.ext.proxy.commons.TransactionalPersistenceManagerImpl;
import org.apache.olingo.ext.proxy.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService<C extends EdmEnabledODataClient> {
    private static final Set<String> DEFAULT_ALLOWED_CLASSES = Collections.singleton("org.apache.olingo.*");
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractService.class);
    private final Map<Class<?>, Object> ENTITY_CONTAINERS = new ConcurrentHashMap();
    private final EdmEnabledODataClient client;
    private final Context context;
    private final boolean transactional;
    private PersistenceManager persistenceManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractService(String compressedMetadata, String metadataETag, ODataServiceVersion version, String serviceRoot, boolean transactional) {
        EdmProviderImpl edm;
        ByteArrayInputStream bais = null;
        GZIPInputStream gzis = null;
        ObjectInputStream ois = null;
        XMLMetadata metadata = null;
        try {
            bais = new ByteArrayInputStream(new Base64().decode(compressedMetadata.getBytes("UTF-8")));
            gzis = new GZIPInputStream(bais);
            ois = this.createObjectInputStream(gzis);
            metadata = (XMLMetadata)ois.readObject();
        }
        catch (Exception e) {
            try {
                LOG.error("While deserializing compressed metadata", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                IOUtils.closeQuietly(gzis);
                IOUtils.closeQuietly(bais);
                throw throwable;
            }
            IOUtils.closeQuietly(ois);
            IOUtils.closeQuietly(gzis);
            IOUtils.closeQuietly(bais);
        }
        IOUtils.closeQuietly(ois);
        IOUtils.closeQuietly(gzis);
        IOUtils.closeQuietly(bais);
        if (metadata != null) {
            ClientCsdlEdmProvider provider = new ClientCsdlEdmProvider(metadata.getSchemaByNsOrAlias());
            edm = new EdmProviderImpl(provider);
        } else {
            edm = null;
        }
        if (version.compareTo(ODataServiceVersion.V40) < 0) {
            throw new ODataRuntimeException("Only OData V4 or higher supported.");
        }
        this.client = ODataClientFactory.getEdmEnabledClient(serviceRoot, edm, metadataETag);
        this.client.getConfiguration().setDefaultPubFormat(ContentType.JSON_FULL_METADATA);
        this.transactional = transactional;
        this.context = new Context();
    }

    public abstract Class<?> getEntityTypeClass(String var1);

    public abstract Class<?> getComplexTypeClass(String var1);

    public abstract Class<?> getEnumTypeClass(String var1);

    public abstract Class<? extends AbstractTerm> getTermClass(String var1);

    public C getClient() {
        return (C)this.client;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceManager getPersistenceManager() {
        AbstractService abstractService = this;
        synchronized (abstractService) {
            if (this.persistenceManager == null) {
                this.persistenceManager = this.transactional ? new TransactionalPersistenceManagerImpl(this) : new NonTransactionalPersistenceManagerImpl(this);
            }
        }
        return this.persistenceManager;
    }

    public <T> T getEntityContainer(Class<T> reference) throws IllegalStateException, IllegalArgumentException {
        if (!this.ENTITY_CONTAINERS.containsKey(reference)) {
            Object entityContainer = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{reference}, (InvocationHandler)EntityContainerInvocationHandler.getInstance(reference, this));
            this.ENTITY_CONTAINERS.put(reference, entityContainer);
        }
        return reference.cast(this.ENTITY_CONTAINERS.get(reference));
    }

    protected Set<String> getAllowedClasses() {
        return Collections.emptySet();
    }

    private ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        ValidatingObjectInputStream vois = new ValidatingObjectInputStream(is);
        HashSet<String> allowedClasses = new HashSet<String>();
        allowedClasses.addAll(DEFAULT_ALLOWED_CLASSES);
        allowedClasses.addAll(this.getAllowedClasses());
        for (String clazz : allowedClasses) {
            vois.accept(clazz);
        }
        return vois;
    }
}

