/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.autofill.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class CreditCard {
    private final String number;
    private final String name;
    private final String expiryMonth;
    private final String expiryYear;
    private final String cvc;

    public CreditCard(String number, String name, String expiryMonth, String expiryYear, String cvc) {
        this.number = Objects.requireNonNull(number, "number is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.expiryMonth = Objects.requireNonNull(expiryMonth, "expiryMonth is required");
        this.expiryYear = Objects.requireNonNull(expiryYear, "expiryYear is required");
        this.cvc = Objects.requireNonNull(cvc, "cvc is required");
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public String getExpiryMonth() {
        return this.expiryMonth;
    }

    public String getExpiryYear() {
        return this.expiryYear;
    }

    public String getCvc() {
        return this.cvc;
    }

    private static CreditCard fromJson(JsonInput input) {
        String number = null;
        String name = null;
        String expiryMonth = null;
        String expiryYear = null;
        String cvc = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "number": {
                    number = input.nextString();
                    continue block14;
                }
                case "name": {
                    name = input.nextString();
                    continue block14;
                }
                case "expiryMonth": {
                    expiryMonth = input.nextString();
                    continue block14;
                }
                case "expiryYear": {
                    expiryYear = input.nextString();
                    continue block14;
                }
                case "cvc": {
                    cvc = input.nextString();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CreditCard(number, name, expiryMonth, expiryYear, cvc);
    }
}

