/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.auto.service.AutoService;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.Executable;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;

public class GeckoDriverService
extends FirefoxDriverService {
    public static final String GECKO_DRIVER_EXE_PROPERTY = "webdriver.gecko.driver";

    public GeckoDriverService(File executable, int port, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    public GeckoDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    public static GeckoDriverService createDefaultService() {
        return (GeckoDriverService)new Builder().build();
    }

    static GeckoDriverService createDefaultService(Capabilities caps) {
        return GeckoDriverService.createDefaultService();
    }

    protected void waitUntilAvailable() {
        PortProber.waitForPortUp((int)this.getUrl().getPort(), (int)((int)this.getTimeout().toMillis()), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    protected boolean hasShutdownEndpoint() {
        return false;
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends FirefoxDriverService.Builder<GeckoDriverService, Builder> {
        private FirefoxBinary firefoxBinary;

        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.FIREFOX.is(capabilities)) {
                ++score;
            }
            if (capabilities.getCapability("moz:firefoxOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder usingFirefoxBinary(FirefoxBinary firefoxBinary) {
            Require.nonNull((String)"Firefox binary", (Object)firefoxBinary);
            GeckoDriverService.checkExecutable((File)firefoxBinary.getFile());
            this.firefoxBinary = firefoxBinary;
            return this;
        }

        protected File findDefaultExecutable() {
            return GeckoDriverService.findExecutable((String)"geckodriver", (String)GeckoDriverService.GECKO_DRIVER_EXE_PROPERTY, (String)"https://github.com/mozilla/geckodriver", (String)"https://github.com/mozilla/geckodriver/releases");
        }

        protected List<String> createArgs() {
            ArrayList<String> args = new ArrayList<String>();
            int wsPort = PortProber.findFreePort();
            args.add(String.format("--port=%d", this.getPort()));
            args.add(String.format("--websocket-port=%d", wsPort));
            args.add("--allow-origins");
            args.add(String.format("http://127.0.0.1:%d", wsPort));
            args.add(String.format("http://localhost:%d", wsPort));
            args.add(String.format("http://[::1]:%d", wsPort));
            if (this.firefoxBinary != null) {
                args.add("-b");
                args.add(this.firefoxBinary.getPath());
            } else {
                Optional<Executable> executable = Optional.ofNullable(FirefoxBinary.locateFirefoxBinaryFromSystemProperty());
                executable.ifPresent(e -> {
                    args.add("-b");
                    args.add(e.getPath());
                });
            }
            return Collections.unmodifiableList(args);
        }

        protected GeckoDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                GeckoDriverService service = new GeckoDriverService(exe, port, timeout, args, environment);
                String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
                if (firefoxLogFile != null) {
                    switch (firefoxLogFile) {
                        case "/dev/stdout": {
                            service.sendOutputTo(System.out);
                            break;
                        }
                        case "/dev/stderr": {
                            service.sendOutputTo(System.err);
                            break;
                        }
                        case "/dev/null": {
                            service.sendOutputTo(ByteStreams.nullOutputStream());
                            break;
                        }
                        default: {
                            service.sendOutputTo(new FileOutputStream(firefoxLogFile));
                            break;
                        }
                    }
                } else if (this.getLogFile() != null) {
                    service.sendOutputTo(new FileOutputStream(this.getLogFile()));
                } else {
                    service.sendOutputTo(System.err);
                }
                return service;
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

