/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.compiler;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.Expression;
import net.sourceforge.htmlunit.xpath.axes.LocPathIterator;
import net.sourceforge.htmlunit.xpath.axes.UnionPathIterator;
import net.sourceforge.htmlunit.xpath.axes.WalkerFactory;
import net.sourceforge.htmlunit.xpath.compiler.FunctionTable;
import net.sourceforge.htmlunit.xpath.compiler.OpMap;
import net.sourceforge.htmlunit.xpath.functions.Function;
import net.sourceforge.htmlunit.xpath.functions.WrongNumberArgsException;
import net.sourceforge.htmlunit.xpath.objects.XNumber;
import net.sourceforge.htmlunit.xpath.objects.XString;
import net.sourceforge.htmlunit.xpath.operations.And;
import net.sourceforge.htmlunit.xpath.operations.Bool;
import net.sourceforge.htmlunit.xpath.operations.Div;
import net.sourceforge.htmlunit.xpath.operations.Equals;
import net.sourceforge.htmlunit.xpath.operations.Gt;
import net.sourceforge.htmlunit.xpath.operations.Gte;
import net.sourceforge.htmlunit.xpath.operations.Lt;
import net.sourceforge.htmlunit.xpath.operations.Lte;
import net.sourceforge.htmlunit.xpath.operations.Minus;
import net.sourceforge.htmlunit.xpath.operations.Mod;
import net.sourceforge.htmlunit.xpath.operations.Mult;
import net.sourceforge.htmlunit.xpath.operations.Neg;
import net.sourceforge.htmlunit.xpath.operations.NotEquals;
import net.sourceforge.htmlunit.xpath.operations.Number;
import net.sourceforge.htmlunit.xpath.operations.Operation;
import net.sourceforge.htmlunit.xpath.operations.Or;
import net.sourceforge.htmlunit.xpath.operations.Plus;
import net.sourceforge.htmlunit.xpath.operations.String;
import net.sourceforge.htmlunit.xpath.operations.UnaryOperation;
import net.sourceforge.htmlunit.xpath.patterns.FunctionPattern;
import net.sourceforge.htmlunit.xpath.patterns.StepPattern;
import net.sourceforge.htmlunit.xpath.patterns.UnionPattern;
import net.sourceforge.htmlunit.xpath.res.XPATHMessages;
import net.sourceforge.htmlunit.xpath.xml.dtm.DTMIterator;
import net.sourceforge.htmlunit.xpath.xml.utils.PrefixResolver;

public class Compiler
extends OpMap {
    private int locPathDepth = -1;
    private static final boolean DEBUG = false;
    private PrefixResolver m_currentPrefixResolver = null;
    final ErrorListener m_errorHandler;
    private final FunctionTable m_functionTable;

    public Compiler(ErrorListener errorHandler, FunctionTable fTable) {
        this.m_errorHandler = errorHandler;
        this.m_functionTable = fTable;
    }

    public Expression compile(int opPos) throws TransformerException {
        int op = this.getOp(opPos);
        Expression expr = null;
        switch (op) {
            case 1: {
                expr = this.compile(opPos + 2);
                break;
            }
            case 2: {
                expr = this.or(opPos);
                break;
            }
            case 3: {
                expr = this.and(opPos);
                break;
            }
            case 4: {
                expr = this.notequals(opPos);
                break;
            }
            case 5: {
                expr = this.equals(opPos);
                break;
            }
            case 6: {
                expr = this.lte(opPos);
                break;
            }
            case 7: {
                expr = this.lt(opPos);
                break;
            }
            case 8: {
                expr = this.gte(opPos);
                break;
            }
            case 9: {
                expr = this.gt(opPos);
                break;
            }
            case 10: {
                expr = this.plus(opPos);
                break;
            }
            case 11: {
                expr = this.minus(opPos);
                break;
            }
            case 12: {
                expr = this.mult(opPos);
                break;
            }
            case 13: {
                expr = this.div(opPos);
                break;
            }
            case 14: {
                expr = this.mod(opPos);
                break;
            }
            case 16: {
                expr = this.neg(opPos);
                break;
            }
            case 17: {
                expr = this.string(opPos);
                break;
            }
            case 18: {
                expr = this.bool(opPos);
                break;
            }
            case 19: {
                expr = this.number(opPos);
                break;
            }
            case 20: {
                expr = this.union(opPos);
                break;
            }
            case 21: {
                expr = this.literal(opPos);
                break;
            }
            case 23: {
                expr = this.group(opPos);
                break;
            }
            case 27: {
                expr = this.numberlit(opPos);
                break;
            }
            case 26: {
                expr = this.arg(opPos);
                break;
            }
            case 25: {
                expr = this.compileFunction(opPos);
                break;
            }
            case 28: {
                expr = this.locationPath(opPos);
                break;
            }
            case 29: {
                expr = null;
                break;
            }
            case 30: {
                expr = this.matchPattern(opPos + 2);
                break;
            }
            case 31: {
                expr = this.locationPathPattern(opPos);
                break;
            }
            case 15: {
                this.error("ER_UNKNOWN_OPCODE", new Object[]{"quo"});
                break;
            }
            default: {
                this.error("ER_UNKNOWN_OPCODE", new Object[]{Integer.toString(this.getOp(opPos))});
            }
        }
        return expr;
    }

    private Expression compileOperation(Operation operation, int opPos) throws TransformerException {
        int leftPos = Compiler.getFirstChildPos(opPos);
        int rightPos = this.getNextOpPos(leftPos);
        operation.setLeftRight(this.compile(leftPos), this.compile(rightPos));
        return operation;
    }

    private Expression compileUnary(UnaryOperation unary, int opPos) throws TransformerException {
        int rightPos = Compiler.getFirstChildPos(opPos);
        unary.setRight(this.compile(rightPos));
        return unary;
    }

    protected Expression or(int opPos) throws TransformerException {
        return this.compileOperation(new Or(), opPos);
    }

    protected Expression and(int opPos) throws TransformerException {
        return this.compileOperation(new And(), opPos);
    }

    protected Expression notequals(int opPos) throws TransformerException {
        return this.compileOperation(new NotEquals(), opPos);
    }

    protected Expression equals(int opPos) throws TransformerException {
        return this.compileOperation(new Equals(), opPos);
    }

    protected Expression lte(int opPos) throws TransformerException {
        return this.compileOperation(new Lte(), opPos);
    }

    protected Expression lt(int opPos) throws TransformerException {
        return this.compileOperation(new Lt(), opPos);
    }

    protected Expression gte(int opPos) throws TransformerException {
        return this.compileOperation(new Gte(), opPos);
    }

    protected Expression gt(int opPos) throws TransformerException {
        return this.compileOperation(new Gt(), opPos);
    }

    protected Expression plus(int opPos) throws TransformerException {
        return this.compileOperation(new Plus(), opPos);
    }

    protected Expression minus(int opPos) throws TransformerException {
        return this.compileOperation(new Minus(), opPos);
    }

    protected Expression mult(int opPos) throws TransformerException {
        return this.compileOperation(new Mult(), opPos);
    }

    protected Expression div(int opPos) throws TransformerException {
        return this.compileOperation(new Div(), opPos);
    }

    protected Expression mod(int opPos) throws TransformerException {
        return this.compileOperation(new Mod(), opPos);
    }

    protected Expression neg(int opPos) throws TransformerException {
        return this.compileUnary(new Neg(), opPos);
    }

    protected Expression string(int opPos) throws TransformerException {
        return this.compileUnary(new String(), opPos);
    }

    protected Expression bool(int opPos) throws TransformerException {
        return this.compileUnary(new Bool(), opPos);
    }

    protected Expression number(int opPos) throws TransformerException {
        return this.compileUnary(new Number(), opPos);
    }

    protected Expression literal(int opPos) {
        opPos = Compiler.getFirstChildPos(opPos);
        return (XString)this.getTokenQueue().elementAt(this.getOp(opPos));
    }

    protected Expression numberlit(int opPos) {
        opPos = Compiler.getFirstChildPos(opPos);
        return (XNumber)this.getTokenQueue().elementAt(this.getOp(opPos));
    }

    protected Expression group(int opPos) throws TransformerException {
        return this.compile(opPos + 2);
    }

    protected Expression arg(int opPos) throws TransformerException {
        return this.compile(opPos + 2);
    }

    protected Expression union(int opPos) throws TransformerException {
        ++this.locPathDepth;
        try {
            LocPathIterator locPathIterator = UnionPathIterator.createUnionIterator(this, opPos);
            return locPathIterator;
        }
        finally {
            --this.locPathDepth;
        }
    }

    public int getLocationPathDepth() {
        return this.locPathDepth;
    }

    FunctionTable getFunctionTable() {
        return this.m_functionTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression locationPath(int opPos) throws TransformerException {
        ++this.locPathDepth;
        try {
            DTMIterator iter = WalkerFactory.newDTMIterator(this, opPos, this.locPathDepth == 0);
            Expression expression = (Expression)((Object)iter);
            return expression;
        }
        finally {
            --this.locPathDepth;
        }
    }

    public Expression predicate(int opPos) throws TransformerException {
        return this.compile(opPos + 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression matchPattern(int opPos) throws TransformerException {
        ++this.locPathDepth;
        try {
            int nextOpPos = opPos;
            int i = 0;
            while (this.getOp(nextOpPos) == 31) {
                nextOpPos = this.getNextOpPos(nextOpPos);
                ++i;
            }
            if (i == 1) {
                Expression expression = this.compile(opPos);
                return expression;
            }
            UnionPattern up = new UnionPattern();
            StepPattern[] patterns = new StepPattern[i];
            i = 0;
            while (this.getOp(opPos) == 31) {
                nextOpPos = this.getNextOpPos(opPos);
                patterns[i] = (StepPattern)this.compile(opPos);
                opPos = nextOpPos;
                ++i;
            }
            up.setPatterns(patterns);
            UnionPattern unionPattern = up;
            return unionPattern;
        }
        finally {
            --this.locPathDepth;
        }
    }

    public Expression locationPathPattern(int opPos) throws TransformerException {
        opPos = Compiler.getFirstChildPos(opPos);
        return this.stepPattern(opPos, 0, null);
    }

    public int getWhatToShow(int opPos) {
        int axesType = this.getOp(opPos);
        int testType = this.getOp(opPos + 3);
        switch (testType) {
            case 1030: {
                return 128;
            }
            case 1031: {
                return 12;
            }
            case 1032: {
                return 64;
            }
            case 1033: {
                switch (axesType) {
                    case 49: {
                        return 4096;
                    }
                    case 39: 
                    case 51: {
                        return 2;
                    }
                    case 38: 
                    case 42: 
                    case 48: {
                        return -1;
                    }
                }
                if (this.getOp(0) == 30) {
                    return -1283;
                }
                return -3;
            }
            case 35: {
                return 1280;
            }
            case 1034: {
                return 65536;
            }
            case 34: {
                switch (axesType) {
                    case 49: {
                        return 4096;
                    }
                    case 39: 
                    case 51: {
                        return 2;
                    }
                    case 52: 
                    case 53: {
                        return 1;
                    }
                }
                return 1;
            }
        }
        return -1;
    }

    protected StepPattern stepPattern(int opPos, int stepCount, StepPattern ancestorPattern) throws TransformerException {
        StepPattern pattern;
        int argLen;
        int startOpPos = opPos;
        int stepType = this.getOp(opPos);
        if (-1 == stepType) {
            return null;
        }
        int endStep = this.getNextOpPos(opPos);
        switch (stepType) {
            case 25: {
                argLen = this.getOp(opPos + 1);
                pattern = new FunctionPattern(this.compileFunction(opPos), 10);
                break;
            }
            case 50: {
                argLen = this.getArgLengthOfStep(opPos);
                opPos = Compiler.getFirstChildPosOfStep(opPos);
                pattern = new StepPattern(1280, 10);
                break;
            }
            case 51: {
                argLen = this.getArgLengthOfStep(opPos);
                opPos = Compiler.getFirstChildPosOfStep(opPos);
                pattern = new StepPattern(2, this.getStepNS(startOpPos), this.getStepLocalName(startOpPos), 10);
                break;
            }
            case 52: {
                argLen = this.getArgLengthOfStep(opPos);
                opPos = Compiler.getFirstChildPosOfStep(opPos);
                pattern = new StepPattern(this.getWhatToShow(startOpPos), this.getStepNS(startOpPos), this.getStepLocalName(startOpPos), 0);
                break;
            }
            case 53: {
                argLen = this.getArgLengthOfStep(opPos);
                opPos = Compiler.getFirstChildPosOfStep(opPos);
                pattern = new StepPattern(this.getWhatToShow(startOpPos), this.getStepNS(startOpPos), this.getStepLocalName(startOpPos), 10);
                break;
            }
            default: {
                this.error("ER_UNKNOWN_MATCH_OPERATION", null);
                return null;
            }
        }
        pattern.setPredicates(this.getCompiledPredicates(opPos + argLen));
        if (null != ancestorPattern) {
            pattern.setRelativePathPattern(ancestorPattern);
        }
        StepPattern relativePathPattern = this.stepPattern(endStep, stepCount + 1, pattern);
        return null != relativePathPattern ? relativePathPattern : pattern;
    }

    public Expression[] getCompiledPredicates(int opPos) throws TransformerException {
        int count = this.countPredicates(opPos);
        if (count > 0) {
            Expression[] predicates = new Expression[count];
            this.compilePredicates(opPos, predicates);
            return predicates;
        }
        return null;
    }

    public int countPredicates(int opPos) throws TransformerException {
        int count = 0;
        while (29 == this.getOp(opPos)) {
            ++count;
            opPos = this.getNextOpPos(opPos);
        }
        return count;
    }

    private void compilePredicates(int opPos, Expression[] predicates) throws TransformerException {
        int i = 0;
        while (29 == this.getOp(opPos)) {
            predicates[i] = this.predicate(opPos);
            opPos = this.getNextOpPos(opPos);
            ++i;
        }
    }

    Expression compileFunction(int opPos) throws TransformerException {
        int endFunc = opPos + this.getOp(opPos + 1) - 1;
        opPos = Compiler.getFirstChildPos(opPos);
        int funcID = this.getOp(opPos);
        ++opPos;
        if (-1 != funcID) {
            Function func = this.m_functionTable.getFunction(funcID);
            func.postCompileStep(this);
            try {
                int i = 0;
                int p = opPos;
                while (p < endFunc) {
                    func.setArg(this.compile(p), i);
                    p = this.getNextOpPos(p);
                    ++i;
                }
                func.checkNumberArgs(i);
            }
            catch (WrongNumberArgsException wnae) {
                java.lang.String name = this.m_functionTable.getFunctionName(funcID);
                this.error("ER_ONLY_ALLOWS", new Object[]{name, wnae.getMessage()});
            }
            return func;
        }
        this.error("ER_FUNCTION_TOKEN_NOT_FOUND", null);
        return null;
    }

    @Override
    public void error(java.lang.String msg, Object[] args) throws TransformerException {
        java.lang.String fmsg = XPATHMessages.createXPATHMessage(msg, args);
        if (null == this.m_errorHandler) {
            throw new TransformerException(fmsg);
        }
        this.m_errorHandler.fatalError(new TransformerException(fmsg));
    }

    public PrefixResolver getNamespaceContext() {
        return this.m_currentPrefixResolver;
    }

    public void setNamespaceContext(PrefixResolver pr) {
        this.m_currentPrefixResolver = pr;
    }
}

