/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlMedia;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMException;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.LambdaConstructor;
import net.sourceforge.htmlunit.corejs.javascript.LambdaFunction;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class HTMLMediaElement
extends HTMLElement {
    @JsxConstant
    public static final short HAVE_NOTHING = 0;
    @JsxConstant
    public static final short HAVE_METADATA = 1;
    @JsxConstant
    public static final short HAVE_CURRENT_DATA = 2;
    @JsxConstant
    public static final short HAVE_FUTURE_DATA = 3;
    @JsxConstant
    public static final short HAVE_ENOUGH_DATA = 4;
    @JsxConstant
    public static final short NETWORK_EMPTY = 0;
    @JsxConstant
    public static final short NETWORK_IDLE = 1;
    @JsxConstant
    public static final short NETWORK_LOADING = 2;
    @JsxConstant
    public static final short NETWORK_NO_SOURCE = 3;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLMediaElement() {
    }

    @JsxFunction
    public String canPlayType(String type) {
        HtmlMedia element = (HtmlMedia)this.getDomNodeOrNull();
        if (element == null) {
            return "maybe";
        }
        return element.canPlayType(type);
    }

    @JsxFunction
    public Object play() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_PROMISE)) {
            Scriptable scope = ScriptableObject.getTopLevelScope((Scriptable)this);
            LambdaConstructor ctor = (LambdaConstructor)HTMLMediaElement.getProperty((Scriptable)scope, (String)"Promise");
            LambdaFunction reject = (LambdaFunction)HTMLMediaElement.getProperty((Scriptable)ctor, (String)"reject");
            return reject.call(Context.getCurrentContext(), (Scriptable)this, (Scriptable)ctor, new Object[]{new DOMException("HtmlUnit does not support media play().", 8)});
        }
        return Undefined.instance;
    }

    @JsxFunction
    public void pause() {
    }

    @JsxFunction
    public void load() {
    }

    @Override
    @JsxGetter
    public short getNodeType() {
        HtmlMedia element = (HtmlMedia)this.getDomNodeOrNull();
        if (element == null) {
            return 1;
        }
        return element.getNodeType();
    }

    @Override
    @JsxGetter
    public String getNodeName() {
        return this.getNodeNameCustomize();
    }

    protected String getNodeNameCustomize() {
        HtmlMedia element = (HtmlMedia)this.getDomNodeOrNull();
        if (element == null) {
            return "MEDIA";
        }
        return element.getNodeName();
    }

    @JsxGetter
    public String getSrc() {
        HtmlMedia media = (HtmlMedia)this.getDomNodeOrDie();
        return media.getSrc();
    }

    @JsxSetter
    public void setSrc(String src) {
        HtmlMedia media = (HtmlMedia)this.getDomNodeOrDie();
        media.setSrc(src);
    }

    @JsxGetter
    public String getCurrentSrc() {
        HtmlMedia media = (HtmlMedia)this.getDomNodeOrDie();
        return media.getCurrentSrc();
    }
}

