/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.nutch.util.NutchConfiguration;

public final class ParseText
implements Writable {
    public static final String DIR_NAME = "parse_text";
    private static final byte VERSION = 2;
    private String text;

    public ParseText() {
    }

    public ParseText(String text) {
        this.text = text;
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        switch (version) {
            case 1: {
                this.text = WritableUtils.readCompressedString((DataInput)in);
                break;
            }
            case 2: {
                this.text = Text.readString((DataInput)in);
                break;
            }
            default: {
                throw new VersionMismatchException(2, version);
            }
        }
    }

    public final void write(DataOutput out) throws IOException {
        out.write(2);
        Text.writeString((DataOutput)out, (String)this.text);
    }

    public static final ParseText read(DataInput in) throws IOException {
        ParseText parseText = new ParseText();
        parseText.readFields(in);
        return parseText;
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParseText)) {
            return false;
        }
        ParseText other = (ParseText)o;
        return this.text.equals(other.text);
    }

    public String toString() {
        return this.text;
    }

    public static void main(String[] argv) throws Exception {
        String usage = "ParseText (-local | -dfs <namenode:port>) recno segment";
        if (argv.length < 3) {
            System.out.println("usage:" + usage);
            return;
        }
        Options opts = new Options();
        Configuration conf = NutchConfiguration.create();
        GenericOptionsParser parser = new GenericOptionsParser(conf, opts, argv);
        String[] remainingArgs = parser.getRemainingArgs();
        try (FileSystem fs = FileSystem.get((Configuration)conf);){
            int recno = Integer.parseInt(remainingArgs[0]);
            String segment = remainingArgs[1];
            String filename = new Path(segment, DIR_NAME).toString();
            ParseText parseText = new ParseText();
            ArrayFile.Reader parseTexts = new ArrayFile.Reader(fs, filename, conf);
            parseTexts.get((long)recno, (Writable)parseText);
            System.out.println("Retrieved " + recno + " from file " + filename);
            System.out.println(parseText);
            parseTexts.close();
        }
    }
}

