/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.exec.ProcessDestroyer;

public class ShutdownHookProcessDestroyer
implements ProcessDestroyer,
Runnable {
    private final Vector<Process> processes = new Vector();
    private ProcessDestroyerImpl destroyProcessThread = null;
    private boolean added = false;
    private volatile boolean running = false;

    private void addShutdownHook() {
        if (!this.running) {
            this.destroyProcessThread = new ProcessDestroyerImpl();
            Runtime.getRuntime().addShutdownHook(this.destroyProcessThread);
            this.added = true;
        }
    }

    private void removeShutdownHook() {
        if (this.added && !this.running) {
            boolean removed = Runtime.getRuntime().removeShutdownHook(this.destroyProcessThread);
            if (!removed) {
                System.err.println("Could not remove shutdown hook");
            }
            this.destroyProcessThread.setShouldDestroy(false);
            this.destroyProcessThread.start();
            try {
                this.destroyProcessThread.join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.destroyProcessThread = null;
            this.added = false;
        }
    }

    public boolean isAddedAsShutdownHook() {
        return this.added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Process process) {
        Vector<Process> vector = this.processes;
        synchronized (vector) {
            if (this.processes.size() == 0) {
                this.addShutdownHook();
            }
            this.processes.addElement(process);
            return this.processes.contains(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Process process) {
        Vector<Process> vector = this.processes;
        synchronized (vector) {
            boolean processRemoved = this.processes.removeElement(process);
            if (processRemoved && this.processes.size() == 0) {
                this.removeShutdownHook();
            }
            return processRemoved;
        }
    }

    public int size() {
        return this.processes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Vector<Process> vector = this.processes;
        synchronized (vector) {
            this.running = true;
            Enumeration<Process> e = this.processes.elements();
            while (e.hasMoreElements()) {
                Process process = e.nextElement();
                try {
                    process.destroy();
                }
                catch (Throwable t) {
                    System.err.println("Unable to terminate process during process shutdown");
                }
            }
        }
    }

    private class ProcessDestroyerImpl
    extends Thread {
        private boolean shouldDestroy;

        public ProcessDestroyerImpl() {
            super("ProcessDestroyer Shutdown Hook");
            this.shouldDestroy = true;
        }

        public void run() {
            if (this.shouldDestroy) {
                ShutdownHookProcessDestroyer.this.run();
            }
        }

        public void setShouldDestroy(boolean shouldDestroy) {
            this.shouldDestroy = shouldDestroy;
        }
    }
}

