/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.archive.util.binsearch.ByteBufferInputStream;
import org.archive.util.binsearch.SeekableLineReader;
import org.archive.util.binsearch.SeekableLineReaderFactory;
import org.archive.util.binsearch.impl.MappedSeekableLineReader;

public class MappedSeekableLineReaderFactory
implements SeekableLineReaderFactory {
    static final int DEFAULT_BLOCK_SIZE = 512;
    private File file;
    private RandomAccessFile raf;
    private ByteBufferInputStream bbis;
    private int blockSize;

    public MappedSeekableLineReaderFactory(File file) throws IOException {
        this(file, 512);
    }

    public MappedSeekableLineReaderFactory(File file, int blockSize) throws IOException {
        this.file = file;
        this.blockSize = blockSize;
        this.reload();
    }

    protected synchronized ByteBufferInputStream getBbis() {
        return this.bbis;
    }

    @Override
    public SeekableLineReader get() throws IOException {
        return new MappedSeekableLineReader(this.getBbis(), this.blockSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() throws IOException {
        RandomAccessFile newRAF = new RandomAccessFile(this.file, "r");
        RandomAccessFile oldRAF = this.raf;
        FileChannel newFc = newRAF.getChannel();
        ByteBufferInputStream newBbis = ByteBufferInputStream.map(newFc);
        MappedSeekableLineReaderFactory mappedSeekableLineReaderFactory = this;
        synchronized (mappedSeekableLineReaderFactory) {
            this.bbis = newBbis;
            this.raf = newRAF;
        }
        if (oldRAF != null) {
            oldRAF.close();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.bbis = null;
    }

    @Override
    public long getModTime() {
        return this.file.lastModified();
    }
}

