/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.archive.util.binsearch.SeekableLineReader;
import org.archive.util.binsearch.SeekableLineReaderFactory;
import org.archive.util.binsearch.impl.HDFSSeekableLineReader;

public class HDFSSeekableLineReaderFactory
implements SeekableLineReaderFactory {
    private FileSystem fs;
    private Path path;

    public HDFSSeekableLineReaderFactory(FileSystem fs, Path path) {
        this.fs = fs;
        this.path = path;
    }

    @Override
    public SeekableLineReader get() throws IOException {
        FileStatus status = this.fs.getFileStatus(this.path);
        if (status.isDir()) {
            throw new IOException("Path:" + this.path.toUri().toASCIIString() + " is a directory!");
        }
        long length = status.getLen();
        FSDataInputStream fsdis = this.fs.open(this.path);
        return new HDFSSeekableLineReader(fsdis, length, 4096);
    }

    @Override
    public void close() throws IOException {
        if (this.fs != null) {
            this.fs.close();
        }
    }

    @Override
    public long getModTime() {
        try {
            return this.fs.getFileStatus(this.path).getModificationTime();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public void reload() throws IOException {
    }
}

