/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Properties;

public class IAUtils {
    public static final Charset UTF8 = Charset.forName("utf-8");
    public static final String COMMONS_VERSION = IAUtils.loadCommonsVersion();
    public static final String PUBLISHER = IAUtils.loadCommons("publisher");
    public static final String OPERATOR = IAUtils.loadCommons("operator");
    public static final String WAT_WARCINFO_DESCRIPTION = IAUtils.loadCommons("wat.warcinfo.description");
    public static final String WARC_FORMAT = IAUtils.loadCommons("warc.format");
    public static final String WARC_FORMAT_CONFORMS_TO = IAUtils.loadCommons("warc.format.conforms.to");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadCommonsVersion() {
        String version;
        InputStream input = IAUtils.class.getResourceAsStream("/org/archive/ia-web-commons-version.txt");
        if (input == null) {
            return "UNKNOWN";
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(input));
            version = br.readLine();
            br.readLine();
        }
        catch (IOException e) {
            String string;
            try {
                string = e.getMessage();
            }
            catch (Throwable throwable) {
                IAUtils.closeQuietly(br);
                throw throwable;
            }
            IAUtils.closeQuietly(br);
            return string;
        }
        IAUtils.closeQuietly(br);
        return version.trim();
    }

    public static String loadCommons(String id) {
        InputStream input = IAUtils.class.getResourceAsStream("/org/archive/commons.properties");
        InputStreamReader reader = null;
        if (input == null) {
            return "UNKNOWN";
        }
        try {
            reader = new InputStreamReader(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "UNKNOWN";
        }
        Properties prop = new Properties();
        try {
            prop.load(reader);
        }
        catch (IOException e1) {
            return "UNKNOWN";
        }
        if (prop.getProperty(id) != null) {
            return prop.getProperty(id);
        }
        return "UNKNOWN";
    }

    public static void closeQuietly(Object input) {
        if (input == null || !(input instanceof Closeable)) {
            return;
        }
        try {
            ((Closeable)input).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

