/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.io.stream;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.opensearch.common.Nullable;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.BytesStream;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.ByteArray;

public class BytesStreamOutput
extends BytesStream {
    protected final BigArrays bigArrays;
    @Nullable
    protected ByteArray bytes;
    protected int count;

    public BytesStreamOutput() {
        this(0);
    }

    public BytesStreamOutput(int expectedSize) {
        this(expectedSize, BigArrays.NON_RECYCLING_INSTANCE);
    }

    protected BytesStreamOutput(int expectedSize, BigArrays bigArrays) {
        this.bigArrays = bigArrays;
        if (expectedSize != 0) {
            this.bytes = bigArrays.newByteArray(expectedSize, false);
        }
    }

    @Override
    public long position() {
        return this.count;
    }

    @Override
    public void writeByte(byte b) {
        this.ensureCapacity((long)this.count + 1L);
        this.bytes.set(this.count, b);
        ++this.count;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (b.length < offset + length) {
            throw new IllegalArgumentException("Illegal offset " + offset + "/length " + length + " for byte[] of length " + b.length);
        }
        this.ensureCapacity((long)this.count + (long)length);
        this.bytes.set(this.count, b, offset, length);
        this.count += length;
    }

    @Override
    public void reset() {
        if (this.bytes != null && this.bytes.size() > 16384L) {
            this.bytes = this.bigArrays.resize(this.bytes, 16384L);
        }
        this.count = 0;
    }

    @Override
    public void flush() {
    }

    @Override
    public void seek(long position) {
        this.ensureCapacity(position);
        this.count = (int)position;
    }

    public void skip(int length) {
        this.seek((long)this.count + (long)length);
    }

    @Override
    public void close() {
    }

    public int size() {
        return this.count;
    }

    @Override
    public BytesReference bytes() {
        if (this.bytes == null) {
            return BytesArray.EMPTY;
        }
        return BytesReference.fromByteArray(this.bytes, this.count);
    }

    public BytesReference copyBytes() {
        byte[] keyBytes = new byte[this.count];
        int offset = 0;
        BytesRefIterator iterator = this.bytes().iterator();
        try {
            BytesRef slice;
            while ((slice = iterator.next()) != null) {
                System.arraycopy(slice.bytes, slice.offset, keyBytes, offset, slice.length);
                offset += slice.length;
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return new BytesArray(keyBytes);
    }

    public long ramBytesUsed() {
        return this.bytes.ramBytesUsed();
    }

    void ensureCapacity(long offset) {
        if (offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " cannot hold more than 2GB of data");
        }
        this.bytes = this.bytes == null ? this.bigArrays.newByteArray(BigArrays.overSize(offset, 16384, 1), false) : this.bigArrays.grow(this.bytes, offset);
    }
}

