/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.Iterator;
import org.apache.kafka.timeline.Delta;
import org.apache.kafka.timeline.Revertable;
import org.apache.kafka.timeline.Snapshot;
import org.apache.kafka.timeline.SnapshotRegistry;

public class TimelineLong
implements Revertable {
    public static final long INIT = 0L;
    private final SnapshotRegistry snapshotRegistry;
    private long value;

    public TimelineLong(SnapshotRegistry snapshotRegistry) {
        this.snapshotRegistry = snapshotRegistry;
        this.value = 0L;
        snapshotRegistry.register(this);
    }

    public long get() {
        return this.value;
    }

    public long get(long epoch) {
        if (epoch == Long.MAX_VALUE) {
            return this.value;
        }
        Iterator<Snapshot> iterator = this.snapshotRegistry.iterator(epoch);
        while (iterator.hasNext()) {
            Snapshot snapshot = iterator.next();
            LongContainer container = (LongContainer)snapshot.getDelta(this);
            if (container == null) continue;
            return container.value();
        }
        return this.value;
    }

    public void set(long newValue) {
        Snapshot snapshot;
        LongContainer prevContainer;
        Iterator<Snapshot> iterator = this.snapshotRegistry.reverseIterator();
        if (iterator.hasNext() && (prevContainer = (LongContainer)(snapshot = iterator.next()).getDelta(this)) == null) {
            prevContainer = new LongContainer();
            snapshot.setDelta(this, prevContainer);
            prevContainer.setValue(this.value);
        }
        this.value = newValue;
    }

    public void increment() {
        this.set(this.get() + 1L);
    }

    public void decrement() {
        this.set(this.get() - 1L);
    }

    @Override
    public void executeRevert(long targetEpoch, Delta delta) {
        LongContainer container = (LongContainer)delta;
        this.value = container.value();
    }

    @Override
    public void reset() {
        this.set(0L);
    }

    public int hashCode() {
        return (int)this.value ^ (int)(this.value >>> 32);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TimelineLong)) {
            return false;
        }
        TimelineLong other = (TimelineLong)o;
        return this.value == other.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    static class LongContainer
    implements Delta {
        private long value = 0L;

        LongContainer() {
        }

        long value() {
            return this.value;
        }

        void setValue(long value) {
            this.value = value;
        }

        @Override
        public void mergeFrom(long destinationEpoch, Delta delta) {
        }
    }
}

