/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.properties;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.minifi.commons.utils.PropertyUtil;
import org.apache.nifi.properties.ApplicationProperties;

public class BootstrapProperties
extends ApplicationProperties {
    public BootstrapProperties() {
        super(Collections.emptyMap());
    }

    public BootstrapProperties(Properties properties) {
        super(properties);
    }

    public BootstrapProperties(Map<String, String> properties) {
        super(properties);
    }

    public String getProperty(String key) {
        return PropertyUtil.resolvePropertyValue((String)key, (Map)System.getProperties()).or(() -> PropertyUtil.resolvePropertyValue((String)key, System.getenv())).orElseGet(() -> super.getProperty(key));
    }

    public String getProperty(String key, String defaultValue) {
        return PropertyUtil.resolvePropertyValue((String)key, (Map)System.getProperties()).or(() -> PropertyUtil.resolvePropertyValue((String)key, System.getenv())).orElseGet(() -> super.getProperty(key, defaultValue));
    }

    public Set<String> getPropertyKeys() {
        Set systemKeys = System.getProperties().keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        return Stream.of(systemKeys, System.getenv().keySet(), super.getPropertyKeys()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public boolean containsKey(String key) {
        return this.getPropertyKeys().contains(key);
    }
}

