/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.spring;

import org.apache.nifi.controller.status.history.StatusHistoryRepository;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class StatusHistoryRepositoryFactoryBean
implements FactoryBean<StatusHistoryRepository>,
ApplicationContextAware {
    private static final String DEFAULT_COMPONENT_STATUS_REPO_IMPLEMENTATION = "org.apache.nifi.controller.status.history.VolatileComponentStatusRepository";
    private ApplicationContext applicationContext;
    private NiFiProperties nifiProperties;
    private ExtensionManager extensionManager;
    private StatusHistoryRepository statusHistoryRepository;

    public StatusHistoryRepository getObject() throws Exception {
        String implementationClassName = this.nifiProperties.getProperty("nifi.components.status.repository.implementation", DEFAULT_COMPONENT_STATUS_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new BeanCreationException("Cannot create Status History Repository because the NiFi Properties is missing the following property: nifi.components.status.repository.implementation");
        }
        try {
            this.statusHistoryRepository = (StatusHistoryRepository)NarThreadContextClassLoader.createInstance((ExtensionManager)this.extensionManager, (String)implementationClassName, StatusHistoryRepository.class, (NiFiProperties)this.nifiProperties);
            this.statusHistoryRepository.start();
            return this.statusHistoryRepository;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getObjectType() {
        return StatusHistoryRepository.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setNifiProperties(NiFiProperties nifiProperties) {
        this.nifiProperties = nifiProperties;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }
}

