/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;

public class GhostProcessor
implements Processor {
    private String id;
    private String canonicalClassName;

    public void setIdentifier(String id) {
        this.id = id;
    }

    public void setCanonicalClassName(String canonicalClassName) {
        this.canonicalClassName = canonicalClassName;
    }

    public Collection<ValidationResult> validate(ValidationContext context) {
        return Collections.singleton(new ValidationResult.Builder().input("Any Property").subject("Missing Processor").valid(false).explanation("Processor is of type " + this.canonicalClassName + ", but this is not a valid Processor type").build());
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.buildDescriptor(name);
    }

    private PropertyDescriptor buildDescriptor(String propertyName) {
        return new PropertyDescriptor.Builder().name(propertyName).description(propertyName).required(true).sensitive(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
    }

    public List<PropertyDescriptor> getPropertyDescriptors() {
        return Collections.emptyList();
    }

    public String getIdentifier() {
        return this.id;
    }

    public void initialize(ProcessorInitializationContext context) {
    }

    public Set<Relationship> getRelationships() {
        return Collections.emptySet();
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        throw new ProcessException("Unable to instantiate Processor class");
    }

    public String toString() {
        return "GhostProcessor[id=" + this.id + "]";
    }
}

