/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.scheduling;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.scheduling.AbstractSchedulingAgent;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.controller.scheduling.RepositoryContextFactory;
import org.apache.nifi.controller.tasks.ConnectableTask;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTimeBasedSchedulingAgent
extends AbstractSchedulingAgent {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final FlowController flowController;
    protected final RepositoryContextFactory contextFactory;
    protected volatile String adminYieldDuration = "1 sec";

    public AbstractTimeBasedSchedulingAgent(FlowEngine flowEngine, FlowController flowController, RepositoryContextFactory contextFactory) {
        super(flowEngine);
        this.flowController = flowController;
        this.contextFactory = contextFactory;
    }

    @Override
    public void doScheduleOnce(Connectable connectable, LifecycleState scheduleState, Callable<Future<Void>> stopCallback) {
        ArrayList<ScheduledFuture> futures = new ArrayList<ScheduledFuture>();
        ConnectableTask connectableTask = new ConnectableTask(this, connectable, this.flowController, this.contextFactory, scheduleState);
        Runnable trigger = () -> {
            connectableTask.invoke();
            try {
                stopCallback.call();
            }
            catch (Exception e) {
                String errorMessage = "Error while stopping " + connectable + " after running once.";
                this.logger.error(errorMessage, (Throwable)e);
                throw new ProcessException(errorMessage, (Throwable)e);
            }
        };
        ScheduledFuture future = this.flowEngine.schedule(trigger, 1L, TimeUnit.NANOSECONDS);
        futures.add(future);
        scheduleState.setFutures(futures);
    }

    public void setAdministrativeYieldDuration(String yieldDuration) {
        this.adminYieldDuration = yieldDuration;
    }

    public String getAdministrativeYieldDuration() {
        return this.adminYieldDuration;
    }

    public long getAdministrativeYieldDuration(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.adminYieldDuration, (TimeUnit)timeUnit);
    }

    public void incrementMaxThreadCount(int toAdd) {
        int corePoolSize = this.flowEngine.getCorePoolSize();
        if (toAdd < 0 && corePoolSize + toAdd < 1) {
            throw new IllegalStateException("Cannot remove " + -toAdd + " threads from pool because there are only " + corePoolSize + " threads in the pool");
        }
        this.flowEngine.setCorePoolSize(corePoolSize + toAdd);
    }
}

