/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.controller.repository.metrics.PerformanceTracker;

public class PerformanceTrackingOutputStream
extends FilterOutputStream {
    private final PerformanceTracker performanceTracker;

    public PerformanceTrackingOutputStream(OutputStream out, PerformanceTracker performanceTracker) {
        super(out);
        this.performanceTracker = performanceTracker;
    }

    @Override
    public void write(int b) throws IOException {
        this.performanceTracker.beginContentWrite();
        try {
            this.out.write(b);
        }
        finally {
            this.performanceTracker.endContentWrite();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.performanceTracker.beginContentWrite();
        try {
            this.out.write(b, off, len);
        }
        finally {
            this.performanceTracker.endContentWrite();
        }
    }

    @Override
    public void close() throws IOException {
        this.performanceTracker.beginContentWrite();
        try {
            super.close();
        }
        finally {
            this.performanceTracker.endContentWrite();
        }
    }

    @Override
    public void flush() throws IOException {
        this.performanceTracker.beginContentWrite();
        try {
            super.flush();
        }
        finally {
            this.performanceTracker.endContentWrite();
        }
    }
}

