/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.RowCursor;
import io.questdb.std.IntLongPriorityQueue;
import io.questdb.std.ObjList;

class HeapRowCursor
implements RowCursor {
    private final IntLongPriorityQueue heap = new IntLongPriorityQueue();
    private ObjList<RowCursor> cursors;

    @Override
    public boolean hasNext() {
        return this.heap.hasNext();
    }

    @Override
    public long next() {
        int idx = this.heap.popIndex();
        RowCursor cursor = this.cursors.getQuick(idx);
        return cursor.hasNext() ? this.heap.popAndReplace(idx, cursor.next()) : this.heap.popValue();
    }

    public void of(ObjList<RowCursor> cursors, int activeCursors) {
        this.cursors = cursors;
        this.heap.clear();
        for (int i = 0; i < activeCursors; ++i) {
            RowCursor cursor = cursors.getQuick(i);
            if (!cursor.hasNext()) continue;
            this.heap.add(i, cursor.next());
        }
    }
}

