/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.datetime.microtime.Timestamps;

final class TimestampFloorFunctions {
    private TimestampFloorFunctions() {
    }

    static class TimestampFloorYYYYFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorYYYYFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorYYYY(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "year";
        }
    }

    static class TimestampFloorWWFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorWWFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorWW(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "week";
        }
    }

    static class TimestampFloorSSFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorSSFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorSS(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "second";
        }
    }

    static class TimestampFloorQuarterFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorQuarterFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorQuarter(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "quarter";
        }
    }

    static class TimestampFloorMillenniumFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorMillenniumFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMillennium(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "millennium";
        }
    }

    static class TimestampFloorMSFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorMSFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMS(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "millisecond";
        }
    }

    static class TimestampFloorMMFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorMMFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMM(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "month";
        }
    }

    static class TimestampFloorMIFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorMIFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMI(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "minute";
        }
    }

    static class TimestampFloorHHFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorHHFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorHH(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "hour";
        }
    }

    static class TimestampFloorDecadeFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorDecadeFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorDecade(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "decade";
        }
    }

    static class TimestampFloorDayOfWeekFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorDayOfWeekFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorDOW(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "week";
        }
    }

    static class TimestampFloorDDFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorDDFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorDD(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "day";
        }
    }

    static class TimestampFloorCenturyFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorCenturyFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorCentury(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "century";
        }
    }

    static abstract class AbstractTimestampFloorFunction
    extends TimestampFunction
    implements UnaryFunction {
        private final Function arg;

        public AbstractTimestampFloorFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public final long getTimestamp(Record rec) {
            long micros = this.arg.getTimestamp(rec);
            return micros == Long.MIN_VALUE ? Long.MIN_VALUE : this.floor(micros);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_floor('").val(this.getUnit()).val("',").val(this.getArg()).val(')');
        }

        protected abstract long floor(long var1);

        abstract CharSequence getUnit();
    }
}

