/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.tree.TreeMetaInfo;
import jetbrains.exodus.tree.btree.BTreeBalancePolicy;
import org.jetbrains.annotations.NotNull;

public class BTreeMetaInfo
extends TreeMetaInfo {
    final BTreeBalancePolicy balancePolicy;

    private BTreeMetaInfo(@NotNull Log log, @NotNull BTreeBalancePolicy balancePolicy, boolean duplicates, int structureId) {
        super(log, duplicates, structureId);
        this.balancePolicy = balancePolicy;
    }

    public BTreeMetaInfo(@NotNull EnvironmentImpl env, boolean duplicates, int structureId) {
        this(env.getLog(), env.getBTreeBalancePolicy(), duplicates, structureId);
    }

    @Override
    public boolean isKeyPrefixing() {
        return false;
    }

    @Override
    public BTreeMetaInfo clone(int newStructureId) {
        return new BTreeMetaInfo(this.log, this.balancePolicy, this.duplicates, newStructureId);
    }

    public static BTreeMetaInfo load(@NotNull EnvironmentImpl env, byte flagsByte, ByteIterator it) {
        boolean duplicates = (flagsByte & 1) != 0;
        CompressedUnsignedLongByteIterable.getInt(it);
        int structureId = CompressedUnsignedLongByteIterable.getInt(it);
        return new BTreeMetaInfo(env, duplicates, structureId);
    }
}

