/*
 * Decompiled with CFR 0.152.
 */
package v21.h2.expression;

import java.util.Map;
import v21.h2.engine.SessionLocal;
import v21.h2.expression.Expression;
import v21.h2.expression.Operation1;
import v21.h2.expression.TypedValueExpression;
import v21.h2.message.DbException;
import v21.h2.mvstore.db.Store;
import v21.h2.util.ParserUtil;
import v21.h2.value.ExtTypeInfoRow;
import v21.h2.value.TypeInfo;
import v21.h2.value.Value;
import v21.h2.value.ValueNull;
import v21.h2.value.ValueRow;

public final class FieldReference
extends Operation1 {
    private final String fieldName;
    private int ordinal;

    public FieldReference(Expression expression, String string) {
        super(expression);
        this.fieldName = string;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder stringBuilder, int n) {
        return ParserUtil.quoteIdentifier(this.arg.getEnclosedSQL(stringBuilder, n).append('.'), this.fieldName, n);
    }

    @Override
    public Value getValue(SessionLocal sessionLocal) {
        Value value = this.arg.getValue(sessionLocal);
        if (value != ValueNull.INSTANCE) {
            return ((ValueRow)value).getList()[this.ordinal];
        }
        return ValueNull.INSTANCE;
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        this.arg = this.arg.optimize(sessionLocal);
        TypeInfo typeInfo = this.arg.getType();
        if (typeInfo.getValueType() != 41) {
            throw Store.getInvalidExpressionTypeException("ROW", this.arg);
        }
        int n = 0;
        for (Map.Entry<String, TypeInfo> entry : ((ExtTypeInfoRow)typeInfo.getExtTypeInfo()).getFields()) {
            if (this.fieldName.equals(entry.getKey())) {
                this.type = typeInfo = entry.getValue();
                this.ordinal = n;
                if (this.arg.isConstant()) {
                    return TypedValueExpression.get(this.getValue(sessionLocal), typeInfo);
                }
                return this;
            }
            ++n;
        }
        throw DbException.get(42122, this.fieldName);
    }
}

