/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public class ArrayByteIterable
extends ByteIterableBase {
    public static final EmptyIterable EMPTY = new EmptyIterable();
    private static final ArrayByteIterable[] SINGLE_BYTE_ITERABLES = new ArrayByteIterable[256];

    public ArrayByteIterable(@NotNull ByteIterable bi) {
        int length = bi.getLength();
        if (length == 0) {
            this.fillBytes(EMPTY_ITERATOR);
        } else {
            byte[] bytes = bi.getBytesUnsafe();
            if (length == 1) {
                this.fillBytes(bytes[0], EMPTY_ITERATOR);
            } else {
                this.length = length;
                this.bytes = bytes;
            }
        }
    }

    public ArrayByteIterable(@NotNull ByteIterator it) {
        this.fillBytes(it);
    }

    public ArrayByteIterable(@NotNull ByteIterator it, int size) {
        this.bytes = ArrayByteIterable.readIterator(it, size);
        this.length = size;
    }

    public ArrayByteIterable(byte firstByte, @NotNull ByteIterable bi) {
        this.fillBytes(firstByte, bi.iterator());
    }

    public ArrayByteIterable(byte firstByte, @NotNull ByteIterator it) {
        this.fillBytes(firstByte, it);
    }

    public ArrayByteIterable(byte[] bytes, int length) {
        if (length == 0) {
            this.fillBytes(EMPTY_ITERATOR);
        } else if (length == 1) {
            this.fillBytes(bytes[0], EMPTY_ITERATOR);
        } else {
            this.bytes = bytes;
            this.length = length;
        }
    }

    public ArrayByteIterable(@NotNull byte[] bytes) {
        this(bytes, bytes.length);
    }

    @Override
    public Iterator iterator() {
        return this.getIterator();
    }

    public Iterator iterator(int offset) {
        return new Iterator(offset);
    }

    public void setBytes(@NotNull byte[] bytes) {
        this.bytes = bytes;
        this.length = bytes.length;
    }

    @Override
    public byte[] getBytesUnsafe() {
        return this.bytes;
    }

    public void writeTo(@NotNull LightOutputStream output) {
        output.write(this.bytes, 0, this.length);
    }

    public static Iterator getEmptyIterator() {
        return ArrayByteIterable.EMPTY.ITERATOR;
    }

    @Override
    protected Iterator getIterator() {
        return new Iterator(0);
    }

    @Override
    protected void fillBytes() {
    }

    public static ArrayByteIterable fromByte(byte b2) {
        return SINGLE_BYTE_ITERABLES[b2 & 0xFF];
    }

    static {
        for (int i = 0; i < SINGLE_BYTE_ITERABLES.length; ++i) {
            ArrayByteIterable.SINGLE_BYTE_ITERABLES[i] = new ArrayByteIterable(SINGLE_BYTES[i]);
        }
    }

    public static final class EmptyIterable
    extends ArrayByteIterable {
        public final Iterator ITERATOR = new Iterator(0);

        EmptyIterable() {
            super(EMPTY_BYTES, 0);
        }

        @Override
        public Iterator iterator(int offset) {
            return this.ITERATOR;
        }

        @Override
        protected Iterator getIterator() {
            return this.ITERATOR;
        }

        @Override
        public void setBytes(@NotNull byte[] bytes) {
            throw new UnsupportedOperationException();
        }
    }

    public class Iterator
    extends ByteIterator {
        private int offset;

        public Iterator(int offset) {
            this.offset = offset;
        }

        @Override
        public boolean hasNext() {
            return this.offset < ArrayByteIterable.this.length;
        }

        @Override
        public byte next() {
            int offset = this.offset;
            byte result = ArrayByteIterable.this.bytes[offset];
            this.offset = offset + 1;
            return result;
        }

        @Override
        public long skip(long bytes) {
            long result = Math.min(bytes, (long)(ArrayByteIterable.this.length - this.offset));
            this.offset += (int)result;
            return result;
        }

        public byte[] getBytesUnsafe() {
            return ArrayByteIterable.this.bytes;
        }

        public int getLength() {
            return ArrayByteIterable.this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int nextBytes(byte[] array, int off, int len) {
            int copyLen = Math.min(len, ArrayByteIterable.this.length - this.offset);
            System.arraycopy(ArrayByteIterable.this.bytes, this.offset, array, off, copyLen);
            this.offset += copyLen;
            return copyLen;
        }
    }
}

