/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import java.io.InputStream;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.vfs.Cluster;
import jetbrains.exodus.vfs.ClusterIterator;
import jetbrains.exodus.vfs.VfsException;
import jetbrains.exodus.vfs.VirtualFileSystem;
import org.jetbrains.annotations.NotNull;

public class VfsInputStream
extends InputStream {
    private final ClusterIterator clusterIterator;

    VfsInputStream(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, long fileDescriptor) {
        this(vfs, txn, fileDescriptor, 0L);
    }

    VfsInputStream(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, long fileDescriptor, long position) {
        long skipped;
        this.clusterIterator = new ClusterIterator(vfs, txn, fileDescriptor, position);
        Cluster current = this.clusterIterator.getCurrent();
        if (current != null && (skipped = current.skip(position -= current.getStartingPosition())) != position) {
            throw new VfsException();
        }
    }

    @Override
    public int read() {
        Cluster current;
        while ((current = this.clusterIterator.getCurrent()) != null) {
            if (current.hasNext()) {
                return current.next() & 0xFF;
            }
            this.clusterIterator.moveToNext();
        }
        return -1;
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) {
        Cluster current = this.clusterIterator.getCurrent();
        if (current == null) {
            return -1;
        }
        if (current.getSize() > 0 && len == 1) {
            b[off] = current.next();
            return 1;
        }
        int readBytes = 0;
        while (current != null && (readBytes += current.nextBytes(b, off + readBytes, len - readBytes)) != len) {
            this.clusterIterator.moveToNext();
            current = this.clusterIterator.getCurrent();
        }
        return readBytes;
    }

    @Override
    public void close() {
        this.clusterIterator.close();
    }

    public boolean isOpen() {
        return !this.clusterIterator.isClosed();
    }

    @Override
    public long skip(long n) {
        long skipped = 0L;
        while (this.clusterIterator.hasCluster() && (skipped += this.clusterIterator.getCurrent().skip(n - skipped)) != n) {
            this.clusterIterator.moveToNext();
        }
        return skipped;
    }

    public boolean isObsolete() {
        return this.clusterIterator.isObsolete();
    }

    public Transaction getTxn() {
        return this.clusterIterator.getTxn();
    }
}

