/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.LatestByValueIndexedRowCursor;

public class LatestByValueDeferredIndexedRowCursorFactory
implements RowCursorFactory {
    private final boolean cachedIndexReaderCursor;
    private final int columnIndex;
    private final LatestByValueIndexedRowCursor cursor = new LatestByValueIndexedRowCursor();
    private final Function symbolFunc;
    private int symbolKey;

    public LatestByValueDeferredIndexedRowCursorFactory(int columnIndex, Function symbolFunc, boolean cachedIndexReaderCursor) {
        this.columnIndex = columnIndex;
        this.symbolFunc = symbolFunc;
        this.symbolKey = -2;
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
    }

    @Override
    public RowCursor getCursor(DataFrame dataFrame) {
        RowCursor cursor;
        if (this.symbolKey != -2 && (cursor = dataFrame.getBitmapIndexReader(this.columnIndex, 2).getCursor(this.cachedIndexReaderCursor, this.symbolKey, dataFrame.getRowLo(), dataFrame.getRowHi() - 1L)).hasNext()) {
            this.cursor.of(cursor.next());
            return this.cursor;
        }
        return EmptyRowCursor.INSTANCE;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isUsingIndex() {
        return true;
    }

    @Override
    public void prepareCursor(TableReader tableReader, SqlExecutionContext sqlExecutionContext) {
        CharSequence symbol = this.symbolFunc.getStr(null);
        this.symbolKey = tableReader.getSymbolMapReader(this.columnIndex).keyOf(symbol);
        if (this.symbolKey != -2) {
            ++this.symbolKey;
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index ").type("backward").type(" scan").meta("on").putBaseColumnNameNoRemap(this.columnIndex).meta("deferred").val(true);
        sink.attr("filter").putBaseColumnNameNoRemap(this.columnIndex).val('=').val(this.symbolFunc);
    }
}

