/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.LimitedSizeLongTreeChain;
import io.questdb.griffin.engine.orderby.LimitedSizeSortedLightRecordCursor;
import io.questdb.griffin.engine.orderby.LongTreeChain;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursor;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursorFactory;
import io.questdb.std.Misc;
import org.jetbrains.annotations.Nullable;

public class LimitedSizeSortedLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final RecordComparator comparator;
    private final CairoConfiguration configuration;
    private final Function hiFunction;
    private final Function loFunction;
    private final ListColumnFilter sortColumnFilter;
    private DelegatingRecordCursor cursor;

    public LimitedSizeSortedLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory base, RecordComparator comparator, Function loFunc, @Nullable Function hiFunc, ListColumnFilter sortColumnFilter) {
        super(metadata);
        this.base = base;
        this.loFunction = loFunc;
        this.hiFunction = hiFunc;
        this.configuration = configuration;
        this.comparator = comparator;
        this.sortColumnFilter = sortColumnFilter;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        boolean preTouchEnabled = executionContext.isColumnPreTouchEnabled();
        executionContext.setColumnPreTouchEnabled(preTouchEnabled && this.hiFunction == null);
        RecordCursor baseCursor = null;
        try {
            baseCursor = this.base.getCursor(executionContext);
            this.initialize(executionContext, baseCursor);
            this.cursor.of(baseCursor, executionContext);
            DelegatingRecordCursor delegatingRecordCursor = this.cursor;
            return delegatingRecordCursor;
        }
        catch (Throwable ex) {
            Misc.free(baseCursor);
            Misc.free(this.cursor);
            throw ex;
        }
        finally {
            executionContext.setColumnPreTouchEnabled(preTouchEnabled);
        }
    }

    @Override
    public boolean implementsLimit() {
        return true;
    }

    public void initializeLimitedSizeCursor(SqlExecutionContext executionContext, RecordCursor base) throws SqlException {
        long limit;
        this.loFunction.init(base, executionContext);
        if (this.hiFunction != null) {
            this.hiFunction.init(base, executionContext);
        }
        long skipFirst = 0L;
        long skipLast = 0L;
        boolean isFirstN = false;
        long lo = this.loFunction.getLong(null);
        if (lo < 0L && this.hiFunction == null) {
            limit = -lo;
        } else if (lo > -1L && this.hiFunction == null) {
            isFirstN = true;
            limit = lo;
        } else {
            long hi = this.hiFunction.getLong(null);
            if (lo < 0L) {
                if (lo < hi) {
                    limit = -lo;
                    skipLast = Math.max(-hi, 0L);
                } else {
                    limit = 0L;
                }
            } else if (hi < 0L) {
                limit = -1L;
                skipFirst = lo;
                skipLast = -hi;
            } else if (hi <= lo) {
                limit = 0L;
            } else {
                isFirstN = true;
                limit = hi;
                skipFirst = lo;
            }
        }
        LimitedSizeLongTreeChain chain = new LimitedSizeLongTreeChain(this.configuration.getSqlSortKeyPageSize(), this.configuration.getSqlSortKeyMaxPages(), this.configuration.getSqlSortLightValuePageSize(), this.configuration.getSqlSortLightValueMaxPages(), isFirstN, limit);
        this.cursor = new LimitedSizeSortedLightRecordCursor(chain, this.comparator, limit, skipFirst, skipLast);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Sort light");
        sink.meta("lo").val(this.loFunction);
        if (this.hiFunction != null) {
            sink.meta("hi").val(this.hiFunction);
        }
        SortedLightRecordCursorFactory.addSortKeys(sink, this.sortColumnFilter);
        sink.child(this.base);
    }

    private boolean canBeOptimized(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
        this.loFunction.init(baseCursor, executionContext);
        if (this.hiFunction != null) {
            this.hiFunction.init(baseCursor, executionContext);
        }
        return this.loFunction.getLong(null) < 0L || this.hiFunction == null || this.hiFunction.getLong(null) >= 0L;
    }

    private void initialize(SqlExecutionContext executionContext, RecordCursor baseCursor) throws SqlException {
        if (this.isInitialized()) {
            return;
        }
        if (this.canBeOptimized(baseCursor, executionContext)) {
            this.initializeLimitedSizeCursor(executionContext, baseCursor);
        } else {
            this.initializeUnlimitedSizeCursor();
        }
    }

    private void initializeUnlimitedSizeCursor() {
        LongTreeChain chain = new LongTreeChain(this.configuration.getSqlSortKeyPageSize(), this.configuration.getSqlSortKeyMaxPages(), this.configuration.getSqlSortLightValuePageSize(), this.configuration.getSqlSortLightValueMaxPages());
        this.cursor = new SortedLightRecordCursor(chain, this.comparator);
    }

    private boolean isInitialized() {
        return this.cursor != null;
    }

    @Override
    protected void _close() {
        this.base.close();
        if (this.cursor != null) {
            this.cursor.close();
        }
    }
}

