/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.Bootstrap;
import io.questdb.MessageBus;
import io.questdb.Metrics;
import io.questdb.PropServerConfiguration;
import io.questdb.TelemetryJob;
import io.questdb.WorkerPoolManager;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnIndexerJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.wal.CheckWalTransactionsJob;
import io.questdb.cairo.wal.WalPurgeJob;
import io.questdb.cairo.wal.WalUtils;
import io.questdb.cutlass.Services;
import io.questdb.cutlass.text.TextImportJob;
import io.questdb.cutlass.text.TextImportRequestJob;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.engine.groupby.vect.GroupByJob;
import io.questdb.griffin.engine.table.AsyncFilterAtom;
import io.questdb.griffin.engine.table.LatestByAllIndexedJob;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.WorkerPool;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import java.io.Closeable;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;

public class ServerMain
implements Closeable {
    private final String banner;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final PropServerConfiguration config;
    private final CairoEngine engine;
    private final FunctionFactoryCache ffCache;
    private final ObjList<Closeable> freeOnExitList = new ObjList();
    private final Log log;
    private final AtomicBoolean running = new AtomicBoolean();
    private final WorkerPoolManager workerPoolManager;

    public ServerMain(String ... args) {
        this(new Bootstrap(args));
    }

    public ServerMain(Bootstrap bootstrap) {
        this(bootstrap.getConfiguration(), bootstrap.getMetrics(), bootstrap.getLog(), bootstrap.getBanner());
    }

    public ServerMain(final PropServerConfiguration config, Metrics metrics, Log log, String banner) {
        this.config = config;
        this.log = log;
        this.banner = banner;
        final CairoConfiguration cairoConfig = config.getCairoConfiguration();
        this.engine = this.freeOnExit(new CairoEngine(cairoConfig, metrics));
        this.ffCache = new FunctionFactoryCache(cairoConfig, ServiceLoader.load(FunctionFactory.class, FunctionFactory.class.getClassLoader()));
        final DatabaseSnapshotAgent snapshotAgent = this.freeOnExit(new DatabaseSnapshotAgent(this.engine));
        final boolean walSupported = config.getCairoConfiguration().isWalSupported();
        final boolean isReadOnly = config.getCairoConfiguration().isReadOnlyInstance();
        this.workerPoolManager = new WorkerPoolManager(config, metrics.health()){

            @Override
            protected void configureSharedPool(WorkerPool sharedPool) {
                try {
                    sharedPool.assign(ServerMain.this.engine.getEngineMaintenanceJob());
                    MessageBus messageBus = ServerMain.this.engine.getMessageBus();
                    sharedPool.assign(new ColumnIndexerJob(messageBus));
                    sharedPool.assign(new GroupByJob(messageBus));
                    sharedPool.assign(new LatestByAllIndexedJob(messageBus));
                    if (!isReadOnly) {
                        O3Utils.setupWorkerPool(sharedPool, ServerMain.this.engine, config.getCairoConfiguration().getCircuitBreakerConfiguration(), ServerMain.this.ffCache);
                        if (walSupported) {
                            sharedPool.assign(new CheckWalTransactionsJob(ServerMain.this.engine));
                            WalPurgeJob walPurgeJob = new WalPurgeJob(ServerMain.this.engine);
                            snapshotAgent.setWalPurgeJobRunLock(walPurgeJob.getRunLock());
                            walPurgeJob.delayByHalfInterval();
                            sharedPool.assign(walPurgeJob);
                            sharedPool.freeOnExit(walPurgeJob);
                            if (!config.getWalApplyPoolConfiguration().isEnabled()) {
                                WalUtils.setupWorkerPool(sharedPool, ServerMain.this.engine, this.getSharedWorkerCount(), ServerMain.this.ffCache);
                            }
                        }
                        TextImportJob.assignToPool(messageBus, sharedPool);
                        if (cairoConfig.getSqlCopyInputRoot() != null) {
                            TextImportRequestJob textImportRequestJob = new TextImportRequestJob(ServerMain.this.engine, Math.max(1, sharedPool.getWorkerCount() - 2), ServerMain.this.ffCache);
                            sharedPool.assign(textImportRequestJob);
                            sharedPool.freeOnExit(textImportRequestJob);
                        }
                    }
                    if (!cairoConfig.getTelemetryConfiguration().getDisableCompletely()) {
                        TelemetryJob telemetryJob = new TelemetryJob(ServerMain.this.engine, ServerMain.this.ffCache);
                        ServerMain.this.freeOnExitList.add(telemetryJob);
                        if (cairoConfig.getTelemetryConfiguration().getEnabled()) {
                            sharedPool.assign(telemetryJob);
                        }
                    }
                }
                catch (Throwable thr) {
                    throw new Bootstrap.BootstrapException(thr);
                }
            }
        };
        if (!isReadOnly && walSupported && config.getWalApplyPoolConfiguration().isEnabled()) {
            WorkerPool walApplyWorkerPool = this.workerPoolManager.getInstance(config.getWalApplyPoolConfiguration(), metrics.health(), WorkerPoolManager.Requester.WAL_APPLY);
            WalUtils.setupWorkerPool(walApplyWorkerPool, this.engine, this.workerPoolManager.getSharedWorkerCount(), this.ffCache);
        }
        this.freeOnExit(Services.createHttpServer(config.getHttpServerConfiguration(), this.engine, this.workerPoolManager, this.ffCache, snapshotAgent, metrics));
        this.freeOnExit(Services.createMinHttpServer(config.getHttpMinServerConfiguration(), this.engine, this.workerPoolManager, metrics));
        this.freeOnExit(Services.createPGWireServer(config.getPGWireConfiguration(), this.engine, this.workerPoolManager, this.ffCache, snapshotAgent, metrics));
        if (!isReadOnly) {
            this.freeOnExit(Services.createLineTcpReceiver(config.getLineTcpReceiverConfiguration(), this.engine, this.workerPoolManager, metrics));
            this.freeOnExit(Services.createLineUdpReceiver(config.getLineUdpReceiverConfiguration(), this.engine, this.workerPoolManager));
        }
        System.gc();
        log.advisoryW().$("bootstrap complete").$();
    }

    public static void main(String[] args) {
        try {
            new ServerMain(args).start(true);
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            LogFactory.closeInstance();
            System.exit(55);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.workerPoolManager.halt();
            for (int i = this.freeOnExitList.size() - 1; i >= 0; --i) {
                Misc.free(this.freeOnExitList.getQuick(i));
            }
            this.freeOnExitList.clear();
        }
    }

    public CairoEngine getCairoEngine() {
        if (this.closed.get()) {
            throw new IllegalStateException("close was called");
        }
        return this.engine;
    }

    public PropServerConfiguration getConfiguration() {
        return this.config;
    }

    public WorkerPoolManager getWorkerPoolManager() {
        if (this.closed.get()) {
            throw new IllegalStateException("close was called");
        }
        return this.workerPoolManager;
    }

    public boolean hasBeenClosed() {
        return this.closed.get();
    }

    public boolean hasStarted() {
        return this.running.get();
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean addShutdownHook) {
        if (!this.closed.get() && this.running.compareAndSet(false, true)) {
            if (addShutdownHook) {
                this.addShutdownHook();
            }
            this.workerPoolManager.start(this.log);
            Bootstrap.logWebConsoleUrls(this.config, this.log, this.banner);
            System.gc();
            this.log.advisoryW().$("enjoy").$();
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                System.err.println("QuestDB is shutting down...");
                System.err.println("Pre-touch magic number: " + AsyncFilterAtom.PRE_TOUCH_BLACK_HOLE.sum());
                this.close();
                LogFactory.closeInstance();
            }
            catch (Error error) {
            }
            finally {
                System.err.println("QuestDB is shutdown.");
            }
        }));
    }

    private <T extends Closeable> T freeOnExit(T closeable) {
        if (closeable != null) {
            this.freeOnExitList.add(closeable);
        }
        return closeable;
    }
}

