/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import jetbrains.exodus.tree.LongIterator;
import jetbrains.exodus.tree.TreeTraverser;
import org.jetbrains.annotations.NotNull;

public class AddressIterator
implements LongIterator {
    @NotNull
    private final TreeTraverser traverser;
    private boolean finished;

    public AddressIterator(@NotNull TreeTraverser traverser) {
        this.traverser = traverser;
        this.finished = false;
        this.traverser.init(true);
    }

    @Override
    public boolean hasNext() {
        return !this.finished;
    }

    @Override
    public long next() {
        long result = this.traverser.getCurrentAddress();
        if (this.traverser.canMoveDown()) {
            this.traverser.moveDown();
            return result;
        }
        if (this.traverser.canMoveRight()) {
            this.traverser.moveRight();
            this.traverser.moveDown();
            return result;
        }
        while (this.traverser.canMoveUp()) {
            if (this.traverser.canMoveRight()) {
                this.traverser.moveRight();
                this.traverser.moveDown();
                return result;
            }
            this.traverser.moveUp();
        }
        if (this.traverser.canMoveRight()) {
            this.traverser.moveRight();
            this.traverser.moveDown();
            return result;
        }
        this.finished = true;
        return result;
    }

    @NotNull
    public TreeTraverser getTraverser() {
        return this.traverser;
    }

    public void skipSubTree() {
    }
}

