/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.selection;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiAttributeEvaluator;

public class MultiMatchAttributeEvaluator
extends MultiAttributeEvaluator {
    private final List<Pattern> attributePatterns = new ArrayList<Pattern>();
    private final int evaluationType;

    public MultiMatchAttributeEvaluator(List<String> attributeRegexes, int evaluationType) {
        for (String regex : attributeRegexes) {
            this.attributePatterns.add(Pattern.compile(regex));
        }
        this.evaluationType = evaluationType;
    }

    @Override
    public int getEvaluationsRemaining(EvaluationContext context) {
        State state = context.getEvaluatorState().getState(this, State.class);
        if (state == null) {
            state = new State();
            context.getEvaluatorState().putState(this, state);
        }
        return state.attributeNames.size() - state.evaluationCount;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        State state = evaluationContext.getEvaluatorState().getState(this, State.class);
        if (state == null) {
            state = new State();
            evaluationContext.getEvaluatorState().putState(this, state);
        }
        if (state.evaluationCount == 0) {
            for (Pattern pattern : this.attributePatterns) {
                for (String attrName : evaluationContext.getExpressionKeys()) {
                    if (!pattern.matcher(attrName).matches()) continue;
                    state.attributeNames.add(attrName);
                }
            }
        }
        if (state.evaluationCount >= state.attributeNames.size()) {
            return new StringQueryResult(null);
        }
        String attributeName = (String)state.attributeNames.get(state.evaluationCount++);
        return new StringQueryResult(evaluationContext.getExpressionValue(attributeName));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return null;
    }

    @Override
    public int getEvaluationType() {
        return this.evaluationType;
    }

    @Override
    public Evaluator<?> getLogicEvaluator() {
        return this;
    }

    private class State {
        private final List<String> attributeNames = new ArrayList<String>();
        private int evaluationCount = 0;

        private State() {
        }
    }
}

