/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.provider.delegating;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.minifi.c2.api.Configuration;
import org.apache.nifi.minifi.c2.api.ConfigurationProvider;
import org.apache.nifi.minifi.c2.api.ConfigurationProviderException;
import org.apache.nifi.minifi.c2.api.InvalidParameterException;
import org.apache.nifi.minifi.c2.api.cache.ConfigurationCache;
import org.apache.nifi.minifi.c2.api.cache.ConfigurationCacheFileInfo;
import org.apache.nifi.minifi.c2.api.cache.WriteableConfiguration;
import org.apache.nifi.minifi.c2.api.security.authorization.AuthorizationException;
import org.apache.nifi.minifi.c2.provider.util.HttpConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingConfigurationProvider
implements ConfigurationProvider {
    public static final Pattern errorPattern = Pattern.compile("^Server returned HTTP response code: ([0-9]+) for URL:.*");
    private static final Logger logger = LoggerFactory.getLogger(DelegatingConfigurationProvider.class);
    private final ConfigurationCache configurationCache;
    private final HttpConnector httpConnector;
    private final ObjectMapper objectMapper;

    public DelegatingConfigurationProvider(ConfigurationCache configurationCache, String delegateUrl) throws InvalidParameterException, GeneralSecurityException, IOException {
        this(configurationCache, new HttpConnector(delegateUrl));
    }

    public DelegatingConfigurationProvider(ConfigurationCache configurationCache, HttpConnector httpConnector) {
        this.configurationCache = configurationCache;
        this.httpConnector = httpConnector;
        this.objectMapper = new ObjectMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getContentTypes() throws ConfigurationProviderException {
        HttpURLConnection httpURLConnection = this.httpConnector.get("/c2/config/contentTypes");
        try {
            List contentTypes = (List)this.objectMapper.readValue(httpURLConnection.getInputStream(), List.class);
            if (logger.isDebugEnabled()) {
                logger.debug("Got content types: " + contentTypes);
            }
            List list = contentTypes;
            httpURLConnection.disconnect();
            return list;
        }
        catch (Throwable throwable) {
            try {
                httpURLConnection.disconnect();
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigurationProviderException("Unable to get content types from delegate.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration(String contentType, Integer version, Map<String, List<String>> parameters) throws ConfigurationProviderException {
        HttpURLConnection remoteC2ServerConnection = null;
        try {
            ConfigurationCacheFileInfo cacheFileInfo;
            WriteableConfiguration configuration;
            if (version == null) {
                remoteC2ServerConnection = this.getDelegateConnection(contentType, parameters);
                version = Integer.parseInt(remoteC2ServerConnection.getHeaderField("X-Content-Version"));
                if (logger.isDebugEnabled()) {
                    logger.debug("Got current version " + version + " from upstream.");
                }
            }
            if (!(configuration = (cacheFileInfo = this.configurationCache.getCacheFileInfo(contentType, parameters)).getConfiguration(version)).exists()) {
                if (remoteC2ServerConnection == null) {
                    remoteC2ServerConnection = this.getDelegateConnection(contentType, parameters);
                }
                try (InputStream inputStream = remoteC2ServerConnection.getInputStream();
                     OutputStream outputStream = configuration.getOutputStream();){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                catch (IOException e) {
                    throw new ConfigurationProviderException("Unable to copy remote configuration to cache.", (Throwable)e);
                }
            }
            WriteableConfiguration writeableConfiguration = configuration;
            return writeableConfiguration;
        }
        finally {
            if (remoteC2ServerConnection != null) {
                remoteC2ServerConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpURLConnection getDelegateConnection(String contentType, Map<String, List<String>> parameters) throws ConfigurationProviderException {
        HttpURLConnection httpURLConnection;
        block14: {
            StringBuilder queryStringBuilder = new StringBuilder();
            try {
                parameters.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEachOrdered(e -> ((List)e.getValue()).stream().sorted().forEachOrdered(v -> {
                    try {
                        queryStringBuilder.append(URLEncoder.encode((String)e.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(v, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new ConfigurationProviderException("Unsupported encoding.", (Throwable)ex).wrap();
                    }
                    queryStringBuilder.append("&");
                }));
            }
            catch (ConfigurationProviderException.Wrapper e2) {
                throw e2.unwrap();
            }
            String url = "/c2/config";
            if (queryStringBuilder.length() > 0) {
                queryStringBuilder.setLength(queryStringBuilder.length() - 1);
                url = url + "?" + queryStringBuilder.toString();
            }
            httpURLConnection = this.httpConnector.get(url);
            httpURLConnection.setRequestProperty("Accepts", contentType);
            try {
                int responseCode;
                try {
                    responseCode = httpURLConnection.getResponseCode();
                }
                catch (IOException e3) {
                    Matcher matcher = errorPattern.matcher(e3.getMessage());
                    if (matcher.matches()) {
                        responseCode = Integer.parseInt(matcher.group(1));
                    }
                    throw e3;
                }
                if (responseCode < 400) break block14;
                String message = "";
                InputStream inputStream = httpURLConnection.getErrorStream();
                if (inputStream != null) {
                    try {
                        message = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                if (responseCode == 400) {
                    throw new InvalidParameterException(message);
                }
                if (responseCode == 403) {
                    throw new AuthorizationException("Got authorization exception from upstream server " + message);
                }
                throw new ConfigurationProviderException(message);
            }
            catch (IOException e4) {
                throw new ConfigurationProviderException("Unable to get response code from upstream server.", (Throwable)e4);
            }
        }
        return httpURLConnection;
    }
}

